package provide ShockNormal 1.0

# THIS procedure puts all the data on a common grid.  The grid is set up
#   with a dt resolution equal to the smallest seen in the data sets and
#   runs over the maximum time limit seen in the data.

proc SNcommonGrid { Dn T1 T2 V1 V2 V3 B1 B2 B3 vInfo } {
   global SNcommon TimE 

   upvar $vInfo vI

   set vL [list Dn T1 T2 V1 V2 V3 B1 B2 B3 ]
   set vN [list N Ti Te V V V B B B ]
   
# THIS is the variable list

   set mID [list B V Ti Te N] 

# ESTABLISH the grid definition to use

   SNgridSet COMMON gI vI

# CONVERT times to integer values which TUdataGrid will handle.

   set nE [array size TimE]
   for { set I 0 } { $I < $nE } { incr I } {
      set Xt($I) [TUtimeConv $SNcommon(BaseT) $TimE($I) 0 SNcommon(Base)]
   }

# GRID the data sets.  This consists of:
#   1.  Determining the number of data points in the data set
#   2.  Gridding the data 
#   3.  Filling any gaps in the grid
#   4.  Copying the grid back into the data array

   set Y(0) 0.0
   set tV [expr $gI(4) * $gI(5)]
   set nV [llength $vL]
   for { set I 0 } { $I < $nV } { incr I } {
      set vA "$[lindex $vL $I]"
      eval upvar $vA DaTa
      if [info exists DaTa] { 
         set viD "[lindex $vN $I]"
         set BeG [lindex $vI($viD) 1]
         set EnD [lindex $vI($viD) 2]
         set nP [expr $EnD - $BeG + 1]
         for { set J 0 ; set K $BeG } { $J < $nP } { incr J ; incr K } { 
             set X($J) $Xt($K)
         }
         TUdataGrid $nP 1 X X $nP Y Y DaTa G Norm gI
         TUgridFill1D G gI X HM -1 1
         unset DaTa
         for { set J 0 } { $J < $tV } { incr J } { set DaTa($J) $G($J) }
      }
   }

# LAST thing to do is to recreate the time array TimE.

   TUgridInfo 32 gI xT 
   unset TimE
   for { set J 0 } { $J < $tV } { incr J } { 
       set TimE($J) [TUtimeConv $SNcommon(BaseT) $xT($J) 1 SNcommon(Base)]
   }

   set SNcommon(nP) $tV
}
