package provide ShockNormal 1.0

# This converts a phi/theta shock normal angle into a set of 5 3D shock normal
# vectors.  These represent the shock normals as the center of a cell and
# at each of the four edges.  The edges are a distance of dP or dT away from 
# the center.  The first vector is at the cell center, followed by the vectors
# at +dP, -dP, +dT and -dT.  Both dP and dT have the dame magnitude.

proc SNcoefExpand { CoeF V } {
   global PI SNcommon

   upvar $CoeF A
   upvar $V  nV

   set dA $SNcommon(dA)

# Cosine and sines of the normal angles.  Off center angles are derived as
# expansions of the center angles

   set cT [expr cos($A(1))]
   set sT [expr sin($A(1))]
   set cP [expr cos($A(0))]
   set sP [expr sin($A(0))]

   set cpT [expr $cT - $sT * $dA]
   set spT [expr $sT + $cT * $dA]
   set cpP [expr $cP - $sP * $dA]
   set spP [expr $sP + $cP * $dA]

   set cmT [expr $cT + $sT * $dA]
   set smT [expr $sT - $cT * $dA]
   set cmP [expr $cP + $sP * $dA]
   set smP [expr $sP - $cP * $dA]

# FORM the normal vectors

   set nV(0) $cT                  
   set nV(1) [expr $cP * $sT]     
   set nV(2) [expr $sP * $sT]     

   set nV(3) $cT                  
   set nV(4) [expr $cpP * $sT]     
   set nV(5) [expr $spP * $sT]     

   set nV(6) $cT                  
   set nV(7) [expr $cmP * $sT]     
   set nV(8) [expr $smP * $sT]     

   set nV(9) $cpT                  
   set nV(10) [expr $cP * $spT]     
   set nV(11) [expr $sP * $spT]     

   set nV(12) $cmT                  
   set nV(13) [expr $cP * $smT]     
   set nV(14) [expr $sP * $smT]     
}
