package provide ShockNormal 1.0
 
proc SNasymSide2 { dAdY Ops }  {
   global SNcommon mRH DeN2 dDeN2  nN2 nP2 nV2 nB2 

   upvar $dAdY dA
   upvar $Ops  oP

# SET twice the density step
 
   set N $oP(5)
   set TdA [ expr .02 * $N ]

# IF looking for the first RH value then solve for all of them and
# their derivitives. After that parcel them out as they are requested.
#
# THE RH values are stored in the array DeN2 and the derivitives are
# stored in the array dDeN2

   if { $oP(4) == 0 } {

# Get the RH model values

      SNasymRHModel $N mRH
      set plusN [expr 1.01 * $N] 
      SNasymRHModel $plusN pRH
      set negN [expr .99 * $N] 
      SNasymRHModel $negN nRH

      set J 0
      for { set I 0 } { $I < $SNcommon(Pt2) } { incr I ; incr J 3 } {
         set V(0) [expr $nN2($I) - $mRH(0)]
         TUvecMath nV2 - mRH V $J 1 1
         TUvecMath nB2 - mRH V $J 4 4
         set V(7) [expr $nN2($I) - $pRH(0)]
         TUvecMath nV2 - pRH V $J 1 8
         TUvecMath nB2 - pRH V $J 4 11
         set V(14) [expr $nN2($I) - $nRH(0)]
         TUvecMath nV2 - nRH V $J 1 15
         TUvecMath nB2 - nRH V $J 4 18
         set DeN2($I) [TUvecMath V MAG V V 0 0 0 7]
         set Pos [TUvecMath V MAG V V 7 7 0 7]
         set Neg [TUvecMath V MAG V V 14 14 0 7]
         set dDeN2($I) [expr ($Pos - $Neg)/$TdA]
      }
   }
   set dA(0) $dDeN2($oP(4))
   return $DeN2($oP(4))
}
