package provide ShockNormal 1.0
 
proc SNasymRHcnst { Base }  {
   global PI SNcommon guiAns nN1 nV1 nB1 nP1 nN2 nV2 nB2 nP2 sP cRH eRH

# COMPUTE some statistics associated with the unitless input data sets
 
   SNrhStat nN1 nP1 nV1 nB1 nN2 nP2 nV2 nB2 Avg Var

# VECTORIZE the computed shock normal
 
   set nV(0) $guiAns(X$Base)
   set nV(1) $guiAns(Y$Base)
   set nV(2) $guiAns(Z$Base)

# SPEED of light (km/s)

   set c [expr 2.9979e5 / $sP(1)]

# SET UP the following tensor.  This depends only on the shock normal
# angles and therefore needs to only be computed once per iteration.  The
# tensor is computed 5 times, once for the cell center and once for each
# of the 4 edges of the cell.
#
#  nT:   1.0 - nVx * nVx      - nVx * nVy       - nVx * nVz
#            - nVy * nVx  1.0 - nVy * nVy       - nVy * nVz
#            - nVz * nVx      - nVz * nVy   1.0 - nVz * nVz
 
   set uT(0) 1.0 ; set uT(1) 0.0 ; set uT(2) 0.0
   set uT(3) 0.0 ; set uT(4) 1.0 ; set uT(5) 0.0
   set uT(6) 0.0 ; set uT(7) 0.0 ; set uT(8) 1.0
   TUvecMath nV TENSOR nV nT 
   TUvecMath uT   -    nT nT 0 0 0 9 9

# COMPUTE the average shock speed

   set cRH(0) $SNcommon(sVi$Base)
   set cRHSq [expr $cRH(0) * $cRH(0)]

# COMPUTE total number of points being processed

   set nTot [expr $SNcommon(Pt1) + $SNcommon(Pt2)] 

# DO side 1 data

   set J 0
   set Pv 0.0
   for { set I 0 } { $I < $SNcommon(Pt1) } { incr I ; incr J 3} {
      set TmP(0) [expr $cRH(0) / $nN1($I)]
      set Vs($I) [TUvecMath nB1 DOT nV nV $J]
      TUmatrixMath nT * nV1 Vn 3 3 3 1 0 $J
      TUmatrixMath nT * nB1 Bn 3 3 3 1 0 $J
      set Pv [expr $Pv + [TUvecMath Bn DOT Bn Bn]]
      set Pn($I) [expr $nP1($I) + $cRHSq / $nN1($I)]
      TUvecMath Vn  * cRH  tV2  0  0  0 3 1
      TUvecMath Bn  *  Vs  tV1  0 $I  0 3 1
      TUvecMath tV2 - tV1   pV  0  0 $J
      TUvecMath Bn  * TmP  tV2  0  0  0 3 1
      TUvecMath Vn  *  Vs  tV1  0 $I  0 3 1
      TUvecMath tV2 - tV1   eV  0  0 $J
   }

# NOW do side 2

   set P $SNcommon(Pt1)
   set Q [expr $P * 3]
   set J 0
   for { set I 0 } { $I < $SNcommon(Pt2) } { incr I ; incr P ; incr J 3} {
      set TmP(0) [expr $cRH(0) / $nN2($I)]
      set Vs($P) [TUvecMath nB2 DOT nV nV $J]
      TUmatrixMath nT * nV2 Vn 3 3 3 1 0 $J
      TUmatrixMath nT * nB2 Bn 3 3 3 1 0 $J
      set Pv [expr $Pv + [TUvecMath Bn DOT Bn Bn]]
      set Pn($P) [expr $nP2($I) + $cRHSq / $nN2($I)]
      TUvecMath Vn  * cRH  tV2  0  0  0 3 1
      TUvecMath Bn  *  Vs  tV1  0 $P  0 3 1
      TUvecMath tV2 - tV1   pV  0  0 $Q
      TUvecMath Bn  * TmP  tV2  0  0  0 3 1
      TUvecMath Vn  *  Vs  tV1  0 $P  0 3 1
      TUvecMath tV2 - tV1   eV  0  0 $Q
      incr Q 3
   }

   set aPv(0) [expr 0.5 * $Pv]
   TUvecMath Pn + aPv  Pn  0  0  0 $nTot 1

# FORM the constants

   set cRH(1) [lindex [TUdataStat Vs $nTot] 0]
   set cRH(2) [lindex [TUdataStat pV $nTot 3 0 ] 0]
   set cRH(3) [lindex [TUdataStat pV $nTot 3 1 ] 0]
   set cRH(4) [lindex [TUdataStat pV $nTot 3 2 ] 0]
   set cRH(5) [expr [lindex [TUdataStat eV $nTot 3 0 ] 0] / $c ]
   set cRH(6) [expr [lindex [TUdataStat eV $nTot 3 1 ] 0] / $c ]
   set cRH(7) [expr [lindex [TUdataStat eV $nTot 3 2 ] 0] / $c ]
   set cRH(8) [lindex [TUdataStat Pn $nTot] 0]

# SINCE these values and combinations of them are used to model the average
#    Rankine-Hugoniot density, velocity, and pressure on either side of the
#    shock it makes since the precompute some of the combinations for
#    later speed.  Do that here.  eRH holds the extended RH constants

# EXTENDED CONSTANT 0 - square of cRH(0)

   set eRH(0) [expr $cRH(0) * $cRH(0)]

# EXTENDED CONSTANT 1 - square of cRH(1)

   set eRH(1) [expr $cRH(1) * $cRH(1)]

# EXTENDED CONSTANTS 2 THRU 4 - cRH(1) times Normal Vector

   TUvecMath nV * cRH eRH 0 1 2 3 1

# EXTENDED CONSTANTS 5 THRU 7 

   set TmP(0) [expr $c * $cRH(0)]
   TUvecMath cRH * TmP aV  5 0 0 3 1
   TUvecMath cRH * cRH bV  2 1 0 3 1
   TUvecMath  aV +  bV eRH 0 0 5

# EXTENDED CONSTANTS 8 THRU 10 - cRH(0) times cRH(2-4)

   TUvecMath cRH * cRH eRH  2 0 8 3 1

# EXTENDED CONSTANTS 11 THRU 13 - cRH(1) times aV

   set TmP(0) [expr $c * $cRH(1)]
   TUvecMath cRH * TmP eRH  5 0 11 3 1

# EXTENDED CONSTANTS 14 THRU 16 - cRH(0) times Normal Vector

   TUvecMath nV * cRH eRH 0 0 14 3 1

# EXTENDED CONSTANTS 17 THRU 19 - SNcommon(sV)) * Normal Vector

   set TmP(0) $SNcommon(sV$Base)
   TUvecMath nV * TmP eRH 0 0 17 3 1
}
