package provide ShockNormal 1.0
 
proc SNasymRHModel { Den MRH }  {
   global PI SNcommon guiAns eRH cRH

  upvar $MRH mRH

# SET the DENSITY 

   set mRH(0) $Den

# COMPUTE intermediate value gS

   set gS(0) [expr $eRH(0) - $Den * $eRH(1)]
 
# COMPUTE the magnetic field values

   set TmP(0) [expr $Den / $gS(0) ]
   TUvecMath eRH * TmP mRH 5 0 4 3 1
   TUvecMath mRH + eRH mRH 4 2 4

# COMPUTE the velocity values
   
   TUvecMath eRH / mRH mRH 14  0 1 3 1
   TUvecMath mRH + eRH mRH  1 17 1
   TUvecMath eRH * mRH  aV 11  0 0 3 1
   TUvecMath eRH +  aV  aV  8
   TUvecMath  aV /  gS  aV  0  0 0 3 1
   TUvecMath mRH +  aV mRH  1  0 1
}
