package provide ptPlots 1.0

proc PTvarList { Var vList { sN 0 } } {
   global ptANS

   upvar $vList vL

   set vL ""

   switch -exact -- $Var {
      COORD {
         set W  .ptCoor.body
         set vL [list [list CoSyS "CARTESIAN" $W.cosys|PRI|O] \
                      [list cPhi 0.0 ""] [list cElev 0.0 ""] \
                      [list pRad 0.2 ""] [list dPhi 30.0 ""] \
                      [list dElev 15.0 ""] [list ElevEnd 90.0 ""] ]
      }
      COR {
         set W  .ptCor.body
         set vL [list [list Vdx "" ""] [list Vdy "" ""] \
	              [list Vdz "" ""] \
		      [list vdFrm FLOW $W.frm|PRI|T] \
	              [list PV "" ""] ]
      }
      CUTS {
         set W  .ptCuts.work
         set vL [list [list xMn "" ""] [list yMn "" ""] \
                      [list xMx "" ""] [list yMx "" ""] \
                      [list cColor #ffffff $W.gc|0|C] \
                      [list cWidth 1 ""] [list sLine  SHOW $W.gl|PRI|T] \
                      [list pAxis  X "$W.pa|PRI|T"] ]
      }
      LABELS {
         set W  .ptLabs.body
         set vL [list [list mLab "" ""] \
	             [list mLSize 12 ""] [list mLColor #000000 $W.mlc|0|C] \
	             [list tLSize 12 ""] [list tLColor #000000 $W.tlc|0|C] \
	             [list PaxSO 10 ""] [list PaxCO #000000 $W.axc|0|C] \
	             [list AxCO #000000 $W.axisc|0|C] \
	             [list PtmSO 0 ""] [list PtmCO #000000 $W.tmc|0|C] \
	             [list PtmBld 0 ""] \
	             [list PscaSO 0 ""] [list PscaCO #000000 $W.scc|0|C] \
	             [list PscaFmt "%.2e" ""] [list PscaBld 0  ""] \
	             [list PmevSO 0 ""] [list PmevCO #ff0000 $W.mevc|0|C] \
	             [list PmevFmt "%.0f" ""] [list PmevBld 0  ""] \
	             [list PcevSO 0 ""] [list PcevCO #0000ff $W.cevc|0|C] \
	             [list PcevFmt "%.0f" ""] [list PcevBld 0  ""] \
		     [list MfHSym {\u25CF} ""] [list MfTSym {\u25B2} ""] \
	             [list MfHS 10 ""] [list MfHC #000000 $W.mfhc|0|C] \
	             [list MfTS 10 ""] [list MfTC #000000 $W.mftc|0|C] \
	             [list MfHac 1 ""] [list MfTac 1 ""] ]
      }
      MASKS {
         set W  .ptMask.work
         set vL [list [list mFmT "" $W.mt|PRI|O] \
                      [list mbEv "0.0" ""] [list meEv "1.0e31" ""] \
                      [list mbPh 0.0 ""] [list mePh 360.0 ""] \
		      [list mbTh 0.0 ""] [list meTh 180.0 ""] \
		      [list pcClip -1.0 ""] \
		      [list mInv NO $W.inv|PRI|T] ]

      }
      FIT {
         set W  .ptFit.body
         set vL [list [list fMethod "OFF" $W.fm|PRI|O] \
                      [list fOrder 1 ""] \
                      [list fFill "DATA" $W.ff|PRI|T] \
                      [list fCut 1.0e3 ""] ]
      }
      PSCRIPT {
         set vL [list [list DoPS 0 ""] [list OvrWrPS 1 ""] \
                   [list psFn "" ""] [list IncH 4 ""] \
                   [list IncS 4 ""] [list IncD 0 ""] \
		   [list IncLw 0 ""] ]
      }
      PSET {
         set W  .ptPSet.body
         set vL [list [list ctbl RainBow $W.ctbl|ALT|O ] \
	              [list xPix 700 ""] [list yPix 600 ""] \
                      [list iMin NONE ""] [list iMax NONE ""] \
                      [list iSca "LINEAR" $W.isc|PRI|T] \
                      [list cFmt "SOLID" $W.cfmt|PRI|O] \
                      [list cLev 10 ""] [list Smooth 1 ""] \
                      [list xGs 10 ""] [list yGs 10 ""] \
                      [list SpinSkip 0 ""] [list sRow 5 ""] \
                      [list LookDir "INST" $W.rf|PRI|T] \
		      [list pMF "NO" $W.pmf|PRI|T] \
		      [list hrMF "NO" $W.hrmf|PRI|T] \
                      [list tDir "HOR" $W.tfl|PRI|T] \
                      [list sPos "NEAREST SPIN" $W.spos|PRI|T] ]
      }
      TIME {
         set vL [list [list yRb "" ""] [list dYb "" ""] \
                      [list hRb 0 ""] [list mNb 0 ""] \
		      [list sCb 0 ""] [list yRe "" ""] \
		      [list dYe "" ""] [list hRe 0 ""] \
		      [list mNe 0 ""] [list sCe 0 ""] ] \
      }
      VARIABLE {
         set W .ptSRC$sN.menu
	 set vL [list [list sID "" ""] [list sType "" ""] [list caaFn "" ""] \
	              [list sBase "" ""] ] 
      }
   }

   return [llength $vL]
}
