# THIS procedure removes the drift velocity for a given energy shell and
#   will return the new set of phi and theta angles if requested.
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTrmDrift { sN eS tE ReadP ReadT NewP NewT } {
   global ptANS pgInfo eVC RtoD GSEtoSC

   upvar $ReadP rP
   upvar $ReadT rT
   upvar $NewP  nP
   upvar $NewT  nT

   set sID [lindex $ptANS(PSrc) $sN]

# PUT the drift into the instrument frame of reference

   if [string match GSE $ptANS(vdFrm)] { 
      set Vd(0) $ptANS($sID,V0)
      set Vd(1) $ptANS($sID,V1)
      set Vd(2) $ptANS($sID,V2)

      if $ptANS(fromSrc) {
         set mF(0) $ptANS($sID,MF0)
         set mF(1) $ptANS($sID,MF1)
         set mF(2) $ptANS($sID,MF2)
	 TUvecMath mF UNIT mF mF

         set pM(0) [expr $mF(0) * $mF(0)]
         set pM(1) [expr $mF(0) * $mF(1)]
         set pM(2) [expr $mF(0) * $mF(2)]
         set pM(3) $pM(1)
	 set pM(4) [expr $mF(1) * $mF(1)]
	 set pM(5) [expr $mF(1) * $mF(2)]
	 set pM(6) $pM(2)
	 set pM(7) $pM(5)
	 set pM(8) [expr $mF(2) * $mF(2)]

	 TUmatrixMath pM * Vd Va 3 3 3 1
	 TUvecMath Vd - Va Vd
      }

      TUmatrixMath GSEtoSC * Vd TmP 3 3 3 1
      set ptANS(Vdx) $TmP(0)
      set ptANS(Vdy) $TmP(1)
      set ptANS(Vdz) $TmP(2)
   } else {
      set ptANS(Vdx) $ptANS($sID,V0)
      set ptANS(Vdy) $ptANS($sID,V1)
      set ptANS(Vdz) $ptANS($sID,V2)
   }

   if [string match FLOW $ptANS(LookDir)] {
      set Vd(0) $ptANS(Vdx)
      set Vd(1) $ptANS(Vdy)
      set Vd(2) $ptANS(Vdz)
   } else {
      set Vd(0) -$ptANS(Vdx)
      set Vd(1) -$ptANS(Vdy)
      set Vd(2) -$ptANS(Vdz)
   }

# COMPUTE the velocity for this energy step

   set pV [expr abs($ptANS($sN,PV0))]
   set V [expr ($eVC($sN,$eS) - $pV + $ptANS(CPV)) * $ptANS(toV)]
   if { $V >= 0.0 } { set V [expr sqrt($V)] } else { set V 0 }

   for { set I 0  } { $I < $tE } { incr I } {
      set pH [expr $rP($I) / $RtoD]
      set cP [ expr cos($pH)]
      set sP [ expr sin($pH)]
      set tH [expr $rT($I) / $RtoD]
      set cT [expr cos($tH)]

# THIS is the velocity in S/C coordinates

      set Vx [expr $V * $cP * $cT - $Vd(0)]
      set Vy [expr $V * $sP * $cT - $Vd(1)]
      set Vz [expr $V * sin($tH) - $Vd(2)]

      set nP($I) [expr atan2($Vy, $Vx) * $RtoD]
      set Vxy [expr sqrt ($Vx * $Vx + $Vy * $Vy)]
      set nT($I) [expr atan2($Vz, $Vxy) * $RtoD]
   }
}
