# THIS procedure process the plot request from the current menu options
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTprocessReq { } {
   global env ptANS GphInfo GSEtoSC DevInfo pgI

   if [string match START $ptANS(State)] {
      PTgetSrcs
      PTopenSrcs
   }

   set nPS [llength $ptANS(PSrc)]

   PTpreCalcs

   set  SkiP  [expr $ptANS(SpinSkip) + 1] 

   PTplotIds
   PTplotSetUp

   PTgridSetup
   PTmainLabs

   PTacqTheta

   set K  0
   set TotP [expr $ptANS(nCol) * $ptANS(nRow)]
   for { set I 0 } { $I < $TotP } { incr K } {
      if { $ptANS(eRow) > 1 } {
         set Row [expr $I % $ptANS(nRow)]  
         set Col [expr $I / $ptANS(nRow)]  
      } else {
         if { $nPS > 1 } {
	    if [string match HOR $ptANS(tDir)] {
               set Row [expr $I % $ptANS(nRow)]  
               set Col [expr $I / $ptANS(nRow)]  
            } else {
               set Row [expr $I / $ptANS(nCol)]  
               set Col [expr $I % $ptANS(nCol)]  
	    }
	 } else {
            set Row [expr $I / $ptANS(nCol)]  
            set Col [expr $I % $ptANS(nCol)]  
         }
      }

#     set sI [expr int($K / $ptANS(eRow)) % $nPS]
      set sI [expr $K % $nPS]
      set sN [lindex $ptANS(PSrc) $sI]
      set sK [expr int($K / $nPS)]

      PTacqSpin $sN ImG Elev Phase 

      PTgetAnc $sN

# COMMENT the above two lines and uncomment the below to produce first
#   a set of plots using the defined fitting and smoothing followed by
#   the same data fit to an SPH function

#if ![info exists CnT] {
#   PTacqSpin ImG Elev Phase 
#   PTgetAnc
#   set CnT 1
#} else { 
#   set ptANS(fMethod) SPH 
#   set ptANS(Smooth) 2 
#   set pgI(4) [expr $ptANS(Sector) * $ptANS(Smooth) ]
#   set pgI(5) [expr $ptANS(0,NSEN) * $ptANS(Smooth) ]
#}

      if { [expr $sK % $SkiP] == 0 } {
#        PTmaskData ImG Phase

	 PTfinalizePhi $sN Phase
	  
         switch -exact -- $ptANS(CoSyS) {
	    VPAVPR_C -
	    VPRVPR_C {
               PTvpvpCPlot $sN $Row $Col ImG Elev Phase
	       incr I
	    }
	    VPAVPR_P -
	    VPRVPR_P {
               PTvpvpPPlot $sN $Row $Col ImG Elev Phase
	       incr I
	    }
	    default {
               for { set J 0 } { $J < $ptANS(eRow) } { incr J ; incr Row } {
	          PTmfPos $sN $Row $Col
                  PTmkPlot $sN $Row $Col ImG Elev Phase
                  PTaddMF $Row $Col
	          incr I
               }
	    }
	 }
      }
   }

   set bC $GphInfo(bColor)
   if $ptANS(cB) {
      set cInputs(pMIN)     $ptANS(iMin)
      set cInputs(pMAX)     $ptANS(iMax)
      set cInputs(pSCA)     $ptANS(iSca)
      set cInputs(WHITE)    NO
      set cInputs(FMT)      RHORIZONTAL
      set cInputs(POS)      RELATIVE
      set cInputs(ANNOTATE) YES
      set cInputs(AXIS)     YES
      set cInputs(PRIMARY)  TICMJ:TICMN:NUM:LABEL
      set cInputs(PNUMS)    3:HOLD
      set cInputs(PSIZE)    HOLD:HOLD:10:10
      set cInputs(PFMTS)    HOLD:HOLD:%.1E
      set cInputs(PCOLORS)  $bC:$bC:$bC:$bC
      set cInputs(SCOLORS)  $bC:$bC:$bC:$bC
      set cInputs(ACOLOR)   $bC
      set cInputs(LEV)      0.5:0.5
      set cInputs(NLEV)     0.5:0.5
      set cInputs(LABELS)   ":$ptANS(uLab)"
      set cA [ColorBar A $ptANS(cBxl) $ptANS(cByb) 0.0 $ptANS(cBxr) \
                       $ptANS(cByt) 0.0 cInputs cI cIb]
   }

#  set cID $DevInfo(Scr$GphInfo(CurScr)).drw
#  $cID postscript -colormap colorMap -file TAIL.ps

#  GPHInteract Initialize
   
   GUIchgConf $DevInfo(Scr$GphInfo(CurScr)).top.status CONTINUE

   PTpscriptOut

   ShowScreen
}
