# THIS procedure omputes the size of an individual PT plot returning the
#   X and Y length

package provide ptPlots 1.0

proc PTplotSize { yTop yBot xRight xLeft pGx pGy } {
   global ptANS GphInfo WinInfo DevInfo

# THIS is the number of defined plot sources

   set nPS [llength $ptANS(PSrc)]

# PRECOMPUTE the actual amount of space available in the X and Y directions 
#   in the parent window for the plots.

   set dX [expr $xRight - $xLeft]
   set dY [expr $yTop - $yBot]

# PRESET the time flow direction. 1 is horizontal and 0 is vertical

   set tF [string match HOR $ptANS(tDir)]

# OK here's where it gets tricky! IF there is one source and one energy 
#   and the time is to flow horizontally then we need to make sure that we 
#   size the plots to fit how many columns of plots the user wants if
#   time is flowing horizontally of how many rows if time is running
#   vertically.

   if { ($nPS == 1) && (($ptANS(eRow) == 1) || $ptANS(VpVp)) } {
      if $tF {
         set minC $ptANS(sRow)
         set minR 1
      } else {
         set minR $ptANS(sRow)
         set minC 1
      }
   } elseif { ($nPS > 1) && ($ptANS(eRow) == 1) } {

#                                 OR

#   If multiple sources and one energy and the time is to flow horizontally 
#   then we also need to make sure that that we size the plots to fit how
#   mand columns of plots are requested AND that we get at least one row
#   of plots per source.

      if $tF {
         set minC $ptANS(sRow)
         set minR $nPS
      } else {
         set minR $ptANS(sRow)
         set minC $nPS
      }
   } elseif { ($nPS > 1) && ($ptANS(eRow) > 1) } {

#                                 OR

#   If multiple source and one energy and the time is to flow horizontally 
#   then we also need to make sure that that we size the plots to fit how
#   mand columns of plots are requested AND that we get at least one row
#   of plots per source.

      set minR $ptANS(eRow)
      set minC $nPS
   } else {

#                                 OR

# THE DEFAULT CONDITION - 1 source and as many rows as energy steps to be
#   output.

      set minC 1
      set minR $ptANS(eRow)
   }

# THE X and Y lengths needed for the needed number of rows of plots is:

   if { $minR > $minC } {
      set dRy [expr int(($dY - ($minR - 1) * $pGy) / double($minR))]
      set dRx [expr $ptANS(XYRatio) * $dRy]

# THIS allows for the following number of rows and columns of plots

      set nR  $minR
      set nC  [expr int($dX / ($dRx + $pGx))]
      if { $nC == 0 } { set nC 1 }
   } else {
      set dRx [expr int(($dX - ($minC - 1) * $pGx) / double($minC))]
      set dRy [expr $dRx / $ptANS(XYRatio)]

# THIS allows for the following number of rows and columns of plots

      set nR  [expr int($dY / ($dRy + $pGy))]
      set nC  $minC
   }

# SET the number of columns which can be output

   if { $nC <= 0 } { set nC 1}
   if { $nR <= 0 } { set nR 1}
   set ptANS(nCol) $nC
   set ptANS(nRow) $nR

   if { $nPS > 1 } {
      if { $ptANS(eRow) > 1 } { 
         set ptANS(nRow) $ptANS(eRow) 
         set intCol [expr int($nC / $nPS)]
	 if { $intCol == 0 } { set intCol 1 }
         set ptANS(nCol) [expr $intCol * $nPS]
      } else {
         if $tF { set ptANS(nRow) $nPS } else { set ptANS(nCol) $nPS }
      }
   } elseif { $ptANS(eRow) > 1 } { set ptANS(nRow) $ptANS(eRow) }

# Return the space used

  return [list $dRx $dRy] 

}
