# THIS puts up all the afterplot annotation
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTplotEnd { sN pN Row Col } {
   global ptANS cInputs GphInfo

   set nPS [llength $ptANS(PSrc)]
   set tD  [string match HOR $ptANS(tDir)]

# ALL colors to the backgrounbd color 

   PlotColor HOLD $GphInfo(bColor) OFF
   PLTinfoChg $pN ALL AXIS COLOR $ptANS(AxCO)
   PLTinfoChg $pN ALL NUMBERS NCOLOR $ptANS(PaxCO)
   PLTinfoChg $pN ALL NUMBERS TCOLOR $ptANS(PaxCO)
   PLTinfoChg $pN ALL TICKS MJCOLOR $ptANS(AxCO)
   PLTinfoChg $pN ALL TICKS MNCOLOR $ptANS(AxCO)

# THIS is the scaling label which is needed unless the there is either
#   a colorbar or no defined minimum color level

   if { $ptANS(cB) || ([string length $cInputs(pMIN)] == 0) } {
      set sLab ""
   } else { set sLab [format "%.2e - %.2e" $cInputs(pMIN) $cInputs(pMAX)] }

# BUST out the time

   set YD  "[lindex $ptANS($sN,bT) 0]/[lindex $ptANS($sN,bT) 1]"
   set HMS [lindex $ptANS($sN,bT) 2]

# THIS is the number of the last Row and Column being plotted

   set lR [expr $ptANS(nRow)- 1]
   set lC [expr $ptANS(nCol)- 1]

# SET the text size 

   set tSize $ptANS(PaxSO)

# SET the axes to be numerically labeled
 
   set XaxisN BOT 
   set YaxisN BOT 

# MAKE sure Y labels are rotated 90 degrees.
 
   PLTinfoChg $pN Yb NUMBERS TANGLE "90.0 0.0 0.0"

# Set up the generic annotation and plot options based on the projection

   switch -exact -- $ptANS(CoSyS) {
      CARTESIAN {
         PLTinfoChg $pN ALL NUMBERS NFORMAT "%.0f"
         PLTinfoChg $pN X TICKS MJNUMBER $ptANS(XTics)
         PLTinfoChg $pN Y TICKS MJNUMBER 6
         PLTinfoChg $pN ALL NUMBERS TSIZE $tSize
         PLTinfoChg $pN ALL NUMBERS NSIZE $tSize
	 set Tics BOTH
	 set LabX PHASE
	 set LabY ELEV
      }
      VPAVPR_C -
      VPAVPR_P {
         PLTinfoChg $pN ALL NUMBERS NFORMAT "%.1e"
         PLTinfoChg $pN X TICKS MJNUMBER $ptANS(XTics)
         PLTinfoChg $pN Y TICKS MJNUMBER 6
         PLTinfoChg $pN ALL NUMBERS TSIZE $tSize
         PLTinfoChg $pN ALL NUMBERS NSIZE $tSize
	 set Tics BOTH
	 set LabX VPARA
	 set LabY VPERP
         if $ptANS(AreCuts) {
	    if { [string first X $ptANS(CutLoc)] >= 0 } { set YaxisN BOTH }
	    if { [string first Y $ptANS(CutLoc)] >= 0 } { set XaxisN BOTH }
         }
      }
      VPRVPR_C -
      VPRVPR_P {
         PLTinfoChg $pN ALL NUMBERS NFORMAT "%.1e"
         PLTinfoChg $pN X TICKS MJNUMBER $ptANS(XTics)
         PLTinfoChg $pN Y TICKS MJNUMBER 6
         PLTinfoChg $pN ALL NUMBERS TSIZE $tSize
         PLTinfoChg $pN ALL NUMBERS NSIZE $tSize
	 set Tics BOTH
	 set LabX "VPERP Y"
	 set LabY "VPERP Z"
         if $ptANS(AreCuts) {
	    if { [string first X $ptANS(CutLoc)] >= 0 } { set YaxisN BOTH }
	    if { [string first Y $ptANS(CutLoc)] >= 0 } { set XaxisN BOTH }
         }
      }
      default {
         PLTinfoChg $pN ALL NUMBERS NFORMAT "%.0f"
         PLTinfoChg $pN ALL NUMBERS TSIZE $tSize
         PLTinfoChg $pN ALL NUMBERS NSIZE $tSize
         PLTinfoChg $pN X TICKS NSTERM $ptANS(ElevEnd)
         PLTinfoChg $pN X TICKS MJSTEP $ptANS(dPhi)
         PLTinfoChg $pN Y TICKS MJSTEP $ptANS(dElev)
         PLTinfoChg $pN ALL TICKS MINTHETA $ptANS(MinElev)
         PLTinfoChg $pN ALL TICKS MAXTHETA $ptANS(MaxElev)
         PLTinfoChg $pN ALL TICKS MINPHI $ptANS(MinPhi)
         PLTinfoChg $pN ALL TICKS MAXPHI $ptANS(MaxPhi)
	 set Tics ALLMAJOR
	 SetCorSys $ptANS(tCoSyS) $ptANS(csInfo)
	 set LabX PHASE
	 set LabY ELEV
      }
   }

# Initialize numerical annotation and axis labels to OFF

   set nOpts [list NONE NONE NONE NONE]
   set LxT "" ; set LxB "" ; set LyL ""

#  if { ($Row == 0) && ($ptANS(eRow) > 1) } { set LxT $HMS } 

# ADD axis labels if this is the lower left hand plot in figure. Only
#  STEREOGRAPHIC plots have no axis labels

   if [string match YES $ptANS(AxisLabs)] {
      if { $Col == 0 } {
         if { $Row == $lR } { set LxB $LabX ; set LyL $LabY }
      }
   }

# SET the Year/Day and Hour/Min/Sec offsets depending on whether there is
#   a colorbar being output

   if $ptANS(cB) {
      set HMSoff 0.8 ; set YDoff 2.5
   } else { set HMSoff 2.0 ; set YDoff 3.25 }

# SET the text size based on the plot size

   PLTinfoChg $pN Xt NUMBERS TSIZE $ptANS(TmTs)

# SET the axis tic/label and numerical annotation options

   if ![string match ORTHOGRAPHIC $ptANS(tCoSyS)] {
      set tOpts [list $LxB 0.25 $LyL 1.0 $LxT $HMSoff "" 1.0]
   } else { set tOpts [list $LxB 1.0 $LyL 1.0 $LxT $HMSoff "" 1.0] }
   if { ($Row == $lR) && ($Col == 0) } { 
      set nOpts [list $XaxisN $YaxisN $Tics $Tics]
   } else { set nOpts [list NONE NONE $Tics $Tics] }

# OUTPUT the plot axis and base labels

   PlotOutlines $pN $tOpts $nOpts [list 0.5 0.5]

   set LabInfo [PTaxisLabs $sN $Row $Col]

   WinClip $pN 0
   if ![string match CARTESIAN $ptANS(tCoSyS)] {
      SetCorSys CARTESIAN [list 0.0 0.0 0.0]
   }

   set nLabs [llength $LabInfo]
   for { set I 0 } { $I < $nLabs } { incr I } {
      set lI [lindex $LabInfo $I]
      set AxiS [lindex $lI 0]
      set Loff [lindex $lI 1]
      set Lcol [lindex $lI 2]
      set Lsiz [lindex $lI 3]
      set Lpos [lindex $lI 4]
      set Ljus [lindex $lI 5]
      set LaB  [lindex $lI 6]
      PLTinfoChg $pN $AxiS NUMBERS TSIZE $Lsiz
      PLTinfoChg $pN $AxiS NUMBERS TCOLOR $Lcol
      PLTaxisRec $pN $AxiS NONE AXIS $Loff $Lpos $Ljus $LaB 
   }
   SetCorSys CARTESIAN [list 0.0 0.0 0.0]

   update
}
