#  THIS procedure opens the UDF files

package provide ptPlots 1.0

proc PTopenUDF { sN bY bD bH bM bS eY eD eH eM eS } {
   global SInfo ptANS Pidf0 ExDa GSEtoSC

   set iD UD$sN
   set sID $ptANS($sN,sID)

# OPEN the main UDF data file from which the moments will be computed

   set Key [GetDataKey $ptANS($iD,P) $ptANS($iD,M) $ptANS($iD,E) \
                          $ptANS($iD,I) $ptANS($iD,V)]

   FileOpen $Key 0 $bY $bD $bH $bM $bS $eY $eD $eH $eM $eS

   if [string match PLOT $ptANS($sN,sType)] {
      if [string match "NEAREST SPIN" $ptANS(sPos)] {
         set sHere COARSE
      } else { set sHere FINE }
      FilePos  $Key 0 $bY $bD $bH $bM $bS $sHere
   } else { FilePos  $Key 0 $bY $bD $bH $bM $bS FINE }

# SAVE the Key

   set ptANS($sN,KeY)   $Key

# FIND out how many sensor definitions are being returned. Each definition
#   can contain multiple measurements but these all use the same algorithm
#   to convert to units.

   set nsD [llength $ptANS($iD,SenL)]

# SET up information variables for each sensor

   set ptANS($sN,sNum) ""
   set ptANS($sN,sUnit) ""
   set ptANS($sN,aUnit) ""
   set ptANS($sN,uName) ""
   set ptANS($sN,sName) ""

   set uD $sN.s0

# Define all of the sensors for this UDF definition

   for { set I 0 } { $I < $nsD } { incr I } {
      if ![lindex $ptANS($iD,SenL) $I] { continue }
      set nD $iD.s$I

# GET all the vidf numbers for all the sensors which need to be retrieved

      set sI [UUgetSensors $Key $ptANS($nD,scr) $ptANS($nD,srcA) \
                                $ptANS($nD,meaA) $ptANS($nD,munA) ] 

# GET the sensor name and unit descriptions

      set vsI [lindex $sI 0]
      set sL [UUgetSNames $Key [lindex $sI 1] FULL]
      set uN [UUgetUNames $Key  $ptANS($nD,munA) LONG]
      if [string match PLOT $ptANS($sN,sType)] {
         set ptANS(uLab) "[lindex $uN 0] ([lindex $uN 1])"
      }

# GET the sensor unit conversion algorithm

      set suN [lindex $uN 1]
      set uS [UUunitAlg $Key,0 $ptANS($nD,munA) $ptANS($nD,meaA)]
      if [string match PLOT $ptANS($sN,sType)] {
         set uA [UUunitAlg $Key,0 $ptANS($nD,iunA) $ptANS($nD,meaA)]
         set ptANS($sID,NSEN) [llength [lindex $sI 0]]
      } else { set uA "" }

# LOAD them up into the definitions

      set nSen [llength $vsI]
      for { set J 0 } { $J < $nSen } { incr J } {
         lappend ptANS($sN,sNum) [lindex $vsI $J]
         lappend ptANS($sN,sUnit)  $uS
         lappend ptANS($sN,aUnit)  $uA
         lappend ptANS($sN,uName) $suN
         lappend ptANS($sN,sName) [lindex $sL $J]
      }
   }

   set ptANS($sN,tChk) 0
   set ptANS($sN,EOF) 0

# IN case we need it form the rotation matrix which will take MF data to
#    PEACE coordinates.  Only work for plots of PEACE data obviously

   set mU UD[lindex $ptANS(PLOT) 0]
   if [string match PEACE $ptANS($mU,E)] {
      set bT [list $bY $bD $bH $bM $bS]
      set eT [list $eY $eD $eH $eM $eS]
      PTtoScSys GSEtoSC PEACE_FGM [list $ptANS($mU,P) $ptANS($mU,M)] $bT $eT
   }
}
