#  THIS procedure opens the CAA files

package provide ptPlots 1.0

proc PTopenCAA { sN sY sD sH sM sS fY fD fH fM fS } {
   global ptANS GSEtoSC

# FIND out what data set this open is for

   if { [lindex $ptANS(MAGFIELD) 0] == $sN } {
      set FmT "%d-%d-%dT%d:%d:%fZ,%f,%f,%f,%f,"
      set rCmD {scan $LiNe $FmT bY bMo bD bH bM bS _T1 S(0) S(1) S(2)}
      set nS 3
   } elseif { [lindex $ptANS(POTENTIAL) 0] == $sN } {
      set FmT "%d-%d-%dT%d:%d:%fZ,%f,%f,"
      set rCmD {scan $LiNe $FmT bY bMo bD bH bM bS _T1 S(0)}
      set nS 1
   } else {
      puts stderr "SOURCE $sN is not a CAA source"
      exit -1
   }

# GET start MS

   set sMs [expr int(($sH * 3600 + $sM * 60 + $sS) * 1000)]
   set tBase 1

# OPEN the file

   if [catch {open $ptANS($sN,caaFn) r} fd ] {
      puts stderr "CAN'T OPEN FILE $ptANS($sN,caaFn) "
      exit -1
   }

# SKIP over the header info

   set StoP 0
   while { !$StoP } {
      gets $fd LiNe
      set LiNe [string trim $LiNe]
      set fS [expr [string first " " $LiNe] - 1]
      if { $fS >= 0 } { set LiNe [string range $LiNe 0 $fS] }
      set StoP [string match DATA_UNTIL $LiNe]
   }

# GET the first time in the file

   set EOF [gets $fd LiNe] 
   eval $rCmD

   set YD [TUtimeFmt 5 $bY $bMo $bD]
   scan $YD "%4d%3d" bY bD
   set bMs [expr int(($bH * 3600 + $bM * 60 + $bS) * 1000)]
   set bT [list $bY $bD $bMs 0]

# GET the difference in seconds from beginning to the requested start time
   
   set ubT [list $sY $sD $sMs 0]

   set tBeg [TUtimeConv $ubT $bT 0 tBase]
   if  { $tBeg >= 0 } { set DonE 1 } else { set DonE 0 }
   set ptANS($sN,dT) 0
   set dTa $bMs
   set dTb -1
   set dTc -1
   set ToK 0

   set EOF [gets $fd LiNe] 
   while { $EOF >= 0 && !$DonE } {
      if { $EOF > 0 } {
         eval $rCmD
         set YD [TUtimeFmt 5 $bY $bMo $bD]
         scan $YD "%4d%3d" bY bD
         set bMs [expr int(($bH * 3600 + $bM * 60 + $bS) * 1000)]
         set bT [list $bY $bD $bMs 0]
	 if !$ToK {
	    if { $dTb >= 0 } { 
	       if { $dTc <= 0 } { 
	          set dTc $bMs
		  set R [expr double ($dTb - $dTa) / double ($dTc - $dTb)]
		  if { (($R < 1.1) && ($R > 0.9)) } { 
		     set ToK 1 
                     set ptANS($sN,dT) [expr $dTb - $dTa]
		  } else {
		    set dTa $dTb
		    set dTb $dTc
		    set dTa -1
		  }
	       } 
	    } else { set dTb $bMs }
         }

         set curT [TUtimeConv $ubT $bT 0 tBase]
	 if { $curT >= 0 } { set DonE 1 } else { set EOF [gets $fd LiNe] }
      }
   }

# GET the start and ending time of this measurement

   set ptANS($sN,bfYr) $bY
   set ptANS($sN,efYr) $bY
   set ptANS($sN,bfDy) $bD
   set ptANS($sN,efDy) $bD
   set ptANS($sN,bfMs) $bMs
   set ptANS($sN,efMs) [expr $bMs + $ptANS($sN,dT)]
   if { $ptANS($sN,efMs) > 86400000 } {
      set ptANS($sN,efMs) [ expr $ptANS($sN,efMs) - 86400000]
      incr ptANS($sN,efDy) 
      if { $$ptANS($sN,efDy) > [TUyearLeap $ptANS($sN,efYr)] } {
         set ptANS($sN,efDy) 1 
         incr ptANS($sN,efYr) 
      }
   }

   if { $EOF > 0 } { set ptANS($sN,EOF) 0 } else { set ptANS($sN,EOF) 1 }
   set ptANS($sN,fd) $fd
   set ptANS($sN,tChk) 2
   for { set I 0 } { $I < $nS } { incr I } {
      set ptANS($sN,cV$I) $S($I)
   }
}
