# ADD MF data to the plot

package provide ptPlots 1.0

proc PTmfPos { sN Row Col } {
   global ptANS GphInfo RtoD GSEtoSC mfInfo

   set mfInfo(0) -10000

# IF there isn't any FM data then no reason to go any further

   if { !$ptANS(MF,ok) || [string match NO $ptANS(pMF)] } { return }

# CHECK if doing hires or normal MF data
#
   if [string match NO $ptANS(hrMF)] {
      set Sets 1 ; set bN MF 
   } else { set Sets $ptANS(nMFhrs) ; set bN hrMF }

# GET the MF which is in GSE into the instrument frame of reference 
#   which is the frame that the plots are output in.

   set nE 0
   set nS 0
   set Base $sN,$bN
   for { set I 0 } { $I < $Sets } { incr I } {
      set v1 $Base$nE ; incr nE
      set v2 $Base$nE ; incr nE
      set v3 $Base$nE ; incr nE

      set mF(0) $ptANS($v1)
      set mF(1) $ptANS($v2)
      set mF(2) $ptANS($v3)

      TUmatrixMath GSEtoSC * mF TmP 3 3 3 1
      set mF(0) $TmP(0)
      set mF(1) $TmP(1)
      set mF(2) $TmP(2)

# NEED to reverse the MF direction if the plot is being output in the
#  instrument and not the flow frame of reference

      if ![string match FLOW $ptANS(LookDir)] {
         set mF(0) [expr -$mF(0)]
         set mF(1) [expr -$mF(1)]
         set mF(2) [expr -$mF(2)]
      }

      set pH [expr atan2($mF(1), $mF(0)) * $RtoD]
#  set pH [expr fmod(360.0 + $pH -10.0, 360.0)]
      set pH [expr fmod(360.0 + $pH, 360.0)]
      if { $ptANS(MinPhi) < 0.0 } {
         if { $pH > $ptANS(MaxPhi) } { set pH [expr $pH - 360.0] }
      }
      set XY [expr sqrt($mF(0) * $mF(0) + $mF(1) * $mF(1))]
      set tH [expr atan2($mF(2), $XY) * $RtoD]

      set mfInfo($nS) $pH ; incr nS
      set mfInfo($nS) $tH ; incr nS
     
#  set pH [expr fmod(180.0 + $pH - 10.0, 360.0)]
      set pH [expr fmod(180.0 + $pH, 360.0)]
      if { $ptANS(pMin) < 0.0 } {
         if { $pH > $ptANS(MaxPhi) } { set pH [expr $pH - 360.0] }
      }
      set tH [expr -$tH]

      set mfInfo($nS) $pH ; incr nS
      set mfInfo($nS) $tH ; incr nS
   }
}
