# THIS masks a region in phase space by setting every value outside the
#    the defined mask to 0.0. The region is defined by limits in E, phi, 
#    and theta if not anchored to B otherwise there is only one phi
#    and theta which is the radius about B (+ or -)

package provide ptPlots 1.0

proc PTmaskData { sN Data gInfo eS } {
   global ptANS eBImG eEImG GSEtoSC RtoD

   upvar $Data dImG
   upvar $gInfo  gI

   set sID $ptANS($sN,sID)

   TUgridInfo 30 gI Xc
   TUgridInfo 31 gI Yc
   TUgridInfo 32 gI xC
   TUgridInfo 33 gI yC

   for { set I 0 } { $I < [expr $gI(4) + 1] } { incr I } {
      if { $Xc($I) < 0.0 } { set Xc($I) [expr 360.0 + $Xc($I)] }
   }

   for { set I 0 } { $I < [expr $gI(5) + 1] } { incr I } {
      set Yc($I) [expr -$Yc($I) + 90] 
   }

# THIS is the text window for clipping and masking

   set W .ptMask.body.list
   if ![winfo exists $W] { PTguiMasks 1 }

# THIS is the number of definitions in the window

   set nF [$W index end]

# THE image sizes

   set tS  [expr $ptANS($sID,NSEN) * $ptANS($sN,nE)]
   set ToT [expr $tS * $ptANS($sN,Sector)]

# LOOP over the definitions and process the clipping ones

   for { set Q 0 } { $Q < $nF } { incr Q } {

# READ the line

      set LiNe [$W get $Q]
      scan $LiNe "%s %f %f %f %f %f %f %f %s" \
            Type eBeg eEnd pBeg pEnd tBeg tEnd pM mInv

      set mA  [string match MASK_A $Type] 
      set mRH [string match MASK_RH $Type] 
      set mRT [string match MASK_RT $Type] 

      if [string match NO $mInv] {
         set Keep 1 ; set Blank 0 ; set Cond ||
      } else { set Keep 0 ; set Blank 1 ; set Cond && }

      if { !$mA && !$mRH && !$mRT } { continue }

# GET the velocity limits and set up the Velocity Mask.  Mask is 1 if
#   the energy step is included and 0 if omitted.

      set vB $eBeg
      set vE $eEnd

      if { $eBImG($sN,0) < $eEImG($sN,0) } { 
         upvar 0 eBImG V1 ; upvar 0 eEImG V2
      } else { upvar 0 eBImG V2 ; upvar 0 eEImG V1 }

      for { set I 0 } { $I < $ptANS($sN,nE) } { incr I } {
         if { ($vB <= $V2($sN,$I)) && ($vE >= $V2($sN,$I)) } {
            set vMask($I) 0
         } else { set vMask($I) 1 }
      }

# MASK is either ABSOLUTE or RELATIVE.  RELATIVE clipping is wrt B
#   and ABSOLUTE is wrt to the entered limits

      if !$mA {

# THIS gets the MF data into the plot frame of reference.  The first
#   rotation gets the MF from GSE into the FLOW frame.  If the data
#   is in the instrument frame then MF needs to be reversed.

         set B(0) $ptANS($sN,MF0)
         set B(1) $ptANS($sN,MF1)
         set B(2) $ptANS($sN,MF2) 
         TUmatrixMath GSEtoSC * B TmP 3 3 3 1
         set B(0) $TmP(0)
         set B(1) $TmP(1)
         set B(2) $TmP(2)

	 if ![string match FLOW $ptANS(LookDir)] {
	    set B(0) [expr -$B(0)]
	    set B(1) [expr -$B(1)]
	    set B(2) [expr -$B(2)]
	 }

# HERE are the equivalent plot angles

         set pH [expr atan2($B(1), $B(0)) * $RtoD]
         set pH [expr fmod(360.0 + $pH, 360.0)]
         set XY [expr sqrt($B(0) * $B(0) + $B(1) * $B(1))]

        if !$mRH {
            set pH [expr fmod(180.0 + $pH, 360.0)]
            set tH [expr 180 - (90.0 - atan2($B(2), $XY) * $RtoD)]
         } else { set tH [expr (90.0 - atan2($B(2), $XY) * $RtoD)] }

         set tB [expr $tH - $tBeg]
         set tE [expr $tH + $tBeg]
         set pB [expr fmod(($pH - $pBeg + 360.0),360)]
         set pE [expr fmod(($pH + $pEnd + 360.0),360)]
      } else {
         set tB $tBeg
         set tE $tEnd
         set pB [expr fmod($pBeg + 360.0, 360.0)]
         set pE [expr fmod($pEnd + 360.0, 360)]
      }   

      if { $Yc(0) < $Yc(1) } { 
         set I 0; set J 1; 
      } else { set I 1; set J 0 }

      if { $tB < 0 } { set t1 [expr -$tB] } else { set t1  0.0 }
      if { $tE > 180.0 } { set t2 [expr 360.0 - $tE] } else { set t2 180.0 }

      for { set K 0  } { $K < $gI(5) } { incr I ; incr J ; incr K } {
         if { ($Yc($I) < $t1) || ($Yc($J) > $t2) } {
            set tMask($K) 2
         } elseif { ($tB < $Yc($J)) && ($tE > $Yc($I)) } {
             set tMask($K) $Keep
         } else { set tMask($K) $Blank }
      }

# PHASE mask

      if { $Xc(0) < $Xc(1) } { 
         set I 0; set J 1; 
      } else { set I 1; set J 0 }

      if { $pB > $pE } {
          set p1 $pB ; set p2 360.0 ; set pB 0.0 
      } else { set p1 $pB ; set p2 $pE }

      for { set K 0  } { $K < $gI(4) } { incr I ; incr J ; incr K } {
         if { $Xc($I) > $Xc($J) } {
	    set pEnD [expr $Xc($J) + 360.0]
         } else { set pEnD $Xc($J) }
         if { ($p1 < $pEnD) && ($p2 >= $Xc($I)) } {
             set pMask($K) $Keep
         } elseif { ($pB < $pEnD) && ($pE >= $Xc($I)) } {
             set pMask($K) $Keep
         } else { set pMask($K) $Blank }
      }

#    Apply the masks to the data image.

      for { set I 0 } { $I < $gI(5) } { incr I } {
         for { set J 0 } { $J < $gI(4) } { incr J } {
	    if { $tMask($I) < 2 } {
	       set mC [expr !$pMask($J) $Cond !$tMask($I)]
            } else { set mC [expr !$Keep] }
            if { !$vMask($eS) && $mC } {
               TUgridInfo 0 gI rV $xC($J) $yC($I)
               set dImG($rV(0)) 0.0 
            }
         }
      }
   }
}
