# THIS procedure contains the PTplots GUI front end.  The GUI is
# based on the GUI used in the UDFAnalysis package.
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTguiMain { } {
   global env ptANS Prefs

# READ in the preference file

   GUIprefsRead

# SET up some basic fonts to use

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]

   if ![winfo exists .ptTOP] {

      . configure -bg $Prefs(FBgCol)

      set Wa .ptTOP
      set Wb .ptMENU
      set Wc .ptBODY

      GUIFrame $Wa -1 pack|top||both
      GUIFrame $Wb -1 pack|top||both
      GUIFrame $Wc -1 pack|left||both

      GUIFrame $Wa.a -1 pack|left||both
      GUIFrame $Wa.b -1 pack|left||both
      GUIFrame $Wa.c -1 pack|right||both
      
      GUIbuttonPush $Wa.a.run  PROCESS  pack|left "PTprocessReq" 6
      GUILabel $Wa.b.acta "" c pack|top 12 36
      GUILabel $Wa.b.actb "" c pack|top 12 36
      GUIbuttonPush $Wa.c.quit QUIT pack|right "exit"  6

      set R 0
      GUILabel $Wb.lim "Input Menu" e grid|$R|0|e 0 0 "" $LFonT
      GUIboxEntry $Wb.im grid|$R|1|news 40 ptANS(MenuRead)
      GUIbuttonPush $Wb.load  LOAD  grid|$R|2|e "PTmenuRead" 0,0.5

      incr R
      GUILabel $Wb.lsm "Save Menu" e grid|$R|0|e 0 0 "" $LFonT
      GUIboxEntry $Wb.sm grid|$R|1|news 40 ptANS(MenuSave) 
      GUIbuttonPush $Wb.save  SAVE  grid|$R|2|e "PTmenuSave" 0,0.5

      set R 0
      GUIblankRow $Wc $R 2.0

      incr R
      GUILabel $Wc.mlab "MENUS" c grid|$R|0 10 0 "" $LFonT
      GUIbuttonPush $Wc.time "TIME DEFINITION" grid|$R|1 "PTguiTime" 6

      incr R
      GUIbuttonPush $Wc.src "VARIABLE DEFINITIONS" grid|$R|1 "PTguiVar" 6

      incr R
      GUIbuttonPush $Wc.ir "ENERGY STEPS" grid|$R|1 "PTgetESteps" 6

      incr R
      GUIbuttonPush $Wc.cs "COORDINATE SYSTEM" grid|$R|1 "PTguiCoor" 6

      incr R
      GUIbuttonPush $Wc.ps "PLOT SETUP" grid|$R|1 "PTguiPSet" 6

      incr R
      GUIbuttonPush $Wc.mask "MASK DEFINITIONS" grid|$R|1 "PTguiMasks" 6

      incr R
      GUIbuttonPush $Wc.fit "FIT OPTIONS" grid|$R|1 "PTguiFits" 6

      incr R
      GUIbuttonPush $Wc.cor "CORRECTIONS" grid|$R|1 "PTguiCor" 6

      incr R
      GUIbuttonPush $Wc.cut "CUTS" grid|$R|1 "PTguiCuts" 6

      incr R
      GUIbuttonPush $Wc.lab "AXES and LABEL OPTIONS" grid|$R|1 "PTguiLabs" 6

      incr R
      GUIbuttonPush $Wc.psg "OUTPUT POSTSCRIPT" grid|$R|1 "PTpscriptGUI" 6

      incr R
      GUIbuttonPush $Wc.agr "GRAPHICS OBJECTS" grid|$R|1 "PTgobjGUI" 6

   }

   update
   bind .ptMENU.im <Return> { .ptMENU.sm delete 0 end ; \
                                    .ptMENU.sm insert end "$ptANS(MenuRead)"}
}
