# THIS procedure defines how to fit the PT data - should that be wanted.  You
#   can fit using a shperical harmonic function or a 2D polynomial.
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTguiFits { } {
   global env ptANS Prefs

   set W .ptFit

    set bSize [expr $Prefs(FontSize) + 2]
    set LFonT [list "" "" bold]
    set BFonT [list "" $bSize bold]

   set LaB "FIT DEFINITION"
   if [GUIWindow $W $LaB] {

      PTallInits FIT

      set Wa $W.cmd
      set Wb $W.body

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb -1 grid|1|0|news
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"

      set OpA [list OFF SPH 2DPOLY]
      set OpB [list DATA GRID]

      set R 0
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Method" w grid|$R|0|w 5 -1 "" $LFonT
      GUIbuttonMenu $Wb.fm $ptANS(fMethod) grid|$R|1| $OpA \
		     "GUIoptsProcess $Wb.fm ptANS(fMethod) PRI "

      incr R 
      GUILabel $Wb.t$R "Order" w grid|$R|0|w 5 -1 "" $LFonT 
      GUIboxEntry $Wb.fo grid|$R|1|w 8 ptANS(fOrder)

      incr R 
      GUILabel $Wb.t$R "Fill" w grid|$R|0|w 5 -1 "" $LFonT 
      GUIbuttonToggle $Wb.ff $ptANS(fFill) grid|$R|1 $OpB \
                    "GUIoptsToggle $Wb.ff ptANS(fFill) PRI" 0

      incr R 
      GUILabel $Wb.t$R "CutOff" w grid|$R|0|w 5 -1 "" $LFonT 
      GUIboxEntry $Wb.fc grid|$R|1|w 8 ptANS(fCut)

   } else { GUIwindowCtrl $W }
}
