#  Get all of the secondary data used in producing the plots.

package provide ptPlots 1.0

proc PTgetAnc { psN } {
   global ptANS 

   set sID $ptANS($psN,sID) 
   set BaD $ptANS(Bad)

   set nV 1

   set nMF [llength $ptANS(MAGFIELD)]
   if { $nMF > 0 } {
      for { set J 0 } { $J < $nMF } { incr J } {
         set sN [lindex $ptANS(MAGFIELD) $J]
         if ![string match $sID $ptANS($sN,sID)] { continue }
      
         if [string match UDF $ptANS($sN,sBase)] {
            if $ptANS($sN,EOF) {
               for { set I 0 } { $I < $nV } { incr I } { set rV($I) $BaD }
            } else { set nV [PTacqUDF $psN $sN rV] }
	    set ptANS(nMFv) $nV ; set ptANS(nMFhrv) $nV 
	    set ptANS(nMFs) 1 ; set ptANS(nMFhrs) 1 
            for { set I 0 } { $I < $nV } { incr I } { 
	       set ptANS($psN,MF$I) $rV($I) 
	       set ptANS($psN,hrMF$I) $rV($I) 
            }
         } else {
            if $ptANS($sN,EOF) {
               for { set I 0 } { $I < $nV } { incr I } { 
	          set rV($I) $BaD 
	          set fV($I) $BaD 
	       }
            } else { set nV [PTacqCAA $psN $sN MAGFIELD rV fV] }

	    set ptANS(nMFv) $nV ; set ptANS(nMFhrv) $fV(nVal)
	    set ptANS(nMFs) 1 ; set ptANS(nMFhrs) $fV(nSets) 

            for { set I 0 } { $I < $nV } { incr I } { 
	       set ptANS($psN,MF$I) $rV($I) 
            }
            for { set I 0 } { $I < $fV(nVal) } { incr I } { 
	       set ptANS($psN,hrMF$I) $fV($I) 
            }
         }
      }
   }

   set nPT [llength $ptANS(POTENTIAL)]
   if { $nPT > 0 } {
      set sN [lindex $ptANS(POTENTIAL) 0]
      for { set J 0 } { $J < $nMF } { incr J } {
         set sN [lindex $ptANS(POTENTIAL) $J]
         if ![string match $sID $ptANS($sN,sID)] { continue }

         if [string match UDF $ptANS($sN,sBase)] {
            set ptANS(CPV) -1.5
            set nV [llength $ptANS($sN,sNum)]
            if !$ptANS($sN,EOF) { 
               set nR [PTacqUDF $psN $sN rV]
	      if { $rV(0) != $BaD } { 
                  for { set I 0 } { $I < $nV } { incr I } { 
	             set ptANS($psN,PV$I) $rV($I) 
	          }
              }
            } else {
               for { set I 0 } { $I < $nV } { incr I } { 
	          set ptANS($psN,PV$I) $BaD 
               }
            }
         }
      }
   }

   set nVE [llength $ptANS(VELOCITY)]
   if { $nVE > 0 } {
      for { set J 0 } { $J < $nVE } { incr J } {
         set sN [lindex $ptANS(VELOCITY) $J]
         if ![string match $sID $ptANS($sN,sID)] { continue }
      
         if [string match UDF $ptANS($sN,sBase)] {
            if $ptANS($sN,EOF) {
               for { set I 0 } { $I < $nV } { incr I } { set rV($I) $BaD }
            } else { set nV [PTacqUDF $psN $sN rV] }
         } else {
            if $ptANS($sN,EOF) {
               for { set I 0 } { $I < $nV } { incr I } { set rV($I) $BaD }
            } else { set nV [PTacqCAA $psN $sN VELOCITY rV fV] }
         }
         for { set I 0 } { $I < $nV } { incr I } { 
	    set ptANS($psN,V$I) [expr $rV($I) * 1000.0] 
	 }
      }
   }
}
