#  THIS procedure checks to see if there has been a time gap.  It does this
#    by checking the time difference between  the end time of the last and 
#    current sweep against the time to acquire one sweep.  If this is larger
#    than ptANS(GapDt) then it is assumed that a gap occurred.
#
#    Gaps of larger than one day are not handled well

package provide ptPlots 1.0

proc PTgapCheck { TeLast TeCurrent } {
   global ptANS

   set dT [expr $TeCurrent - $TeLast]
   if { $dT < 0 } { set dT [expr $dT + 86400000] }
   if { $dT <= $ptANS(GapDt) } { set Status 0 } else { set Status 1 }

   return $Status
}
