# THIS procedure performs a fit to a PT data set
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTfitLevel { N Phase Elev ImG fCoeF } {
   global ptANS RtoD 

   upvar $ImG   V
   upvar $Elev  T
   upvar $Phase P
   upvar $fCoeF C

# THIS is the order of the fit

   set oP(OR) $ptANS(fOrder)

# RESCALE the intensity so the maximum is 1

   set Mx $V([TUdataMxMn V $N >])
   if { $Mx == 0.0 } { set Mx 1.0 }
   for { set I 0 } { $I < $N } { incr I } { set V($I) [expr $V($I) / $Mx] }

# THE rest is mostly fit dependent

   switch -exact -- $ptANS(fMethod) {
      2DPOLY {
	 set rV [TUdataLSq2D P T V $N 0 C iC oP CVar "TUpoly2DFunc"]
	 set nC $oP(NC)
      }
      SPH {
         for { set I 0 } { $I < $N } { incr I } {
            set tH($I) [expr cos(($T($I) + 90.0) / $RtoD)]
         }
	 set rV [TUdataLSq2D P tH V $N 0 C iC oP CVar "TUsphFunc"]
	 set nC $oP(NC)
      }
   }

   return [list $oP(NC) $Mx]
}
