# THIS procedure produces the start and stop edges of the energy bins.

package provide ptPlots 1.0

proc PTeLims { sN } {
   global ptANS eBImG eEImG

#  set sN [lindex $ptANS(PLOT) 0]
   set uA [lindex $ptANS($sN,aUnit) 0]
   ConvertToUnits $ptANS($sN,KeY) 0 0 $uA eV

   set EnD [expr $ptANS($sN,nE) - 1]
   set E1 [expr log($eV(0))]
   set E2 [expr log($eV(1))]
   set dE [expr ($E2 - $E1)/2.0]
   set eBImG($sN,0) [expr exp($E1 - $dE)]
   set eEImG($sN,0) [expr exp($E1 + $dE)]
   set E1 $E2

   for { set I 0 ; set J 1; set K 2 } { $K < $ptANS($sN,nE) } { incr I } {
      set E2 [expr log($eV($K))]
      set dE [expr ($E2 - $E1)/2.0]
      set eBImG($sN,$J) $eEImG($sN,$I) 
      set eEImG($sN,$J) [expr exp($E1 + $dE)] 
      if { $K == $EnD } { 
         set eBImG($sN,$K) $eEImG($sN,$J)
         incr J
         set eEImG($sN,$J) [expr exp($E2 + $dE)]
      }
      set E1 $E2
      incr J
      incr K
   }
}
