# THIS procedure plots values along a cut through the plot grid 

package provide ptPlots 1.0

proc PTcutPlot { sN pN pGrid pgInfo aMn aMx aSca } {
   global ptANS GphInfo WinInfo RtoD GSEtoSC

   upvar $pGrid  pG
   upvar $pgInfo pI

   set W .ptCuts.body.list
   if ![winfo exists $W] { PTguiCuts 1 }
   set nF [$W index end]
   if { $nF == 0 } { return }

# MIGHT as well get the MF data in place in case its called for

   set B(0) $ptANS($sN,MF0)
   set B(1) $ptANS($sN,MF1)
   set B(2) $ptANS($sN,MF2)
   TUmatrixMath GSEtoSC * B TmP 3 3 3 1
   set B(0) $TmP(0)
   set B(1) $TmP(1)
   set B(2) $TmP(2)

# NEED to reverse the MF direction if the plot is geing output in the
#  instrument and not the flow frame of reference

   if ![string match FLOW $ptANS(LookDir)] {
      set B(0) [expr -$B(0)]
      set B(1) [expr -$B(1)]
      set B(2) [expr -$B(2)]
   }

   set pHx [expr atan2($B(1), $B(0)) * $RtoD]
   set pHx [expr fmod(360.0 + $pHx, 360.0)]
   if { $ptANS(MinPhi) < 0.0 } {
      if { $pHx > $ptANS(MaxPhi) } { set pHx [expr $pHx - 360.0] }
   }
   set XY [expr sqrt($B(0) * $B(0) + $B(1) * $B(1))]
   set tHx [expr atan2($B(2), $XY) * $RtoD]
   set pHy [expr fmod(180.0 + $pHx, 360.0)]
   if { $ptANS(pMin) < 0.0 } {
      if { $pHy > $ptANS(MaxPhi) } { set pHy [expr $pHy - 360.0] }
   }
   set tHy [expr -$tHx]

   set LiNe [$W get 0]
   scan $LiNe "%s %s %s %s %s %s %s %s" xMn yMn xMx yMx lC lW sL aX
   SetAxis $pN SECONDARY $aMx $aMn HOLD $aMn $aMx HOLD $aSca $aSca HOLD 0

   set nP [expr 2.0 * $pI(4)]
   for { set I 0 } { $I < $nF } { incr I } {
      set LiNe [$W get $I]
      scan $LiNe "%s %s %s %s %s %s %s %s" xMn yMn xMx yMx lC lW sL aX

       LineStyle $lW

      if [string match MIN $xMn] { set xMn $WinInfo($pN,p0) }
      if [string match MIN $yMn] { set yMn $WinInfo($pN,p1) }
      if [string match MAX $xMx] { set xMx $WinInfo($pN,p3) }
      if [string match MAX $yMx] { set yMx $WinInfo($pN,p4) }
      if [string match MF $xMn]  { set xMn $pHx } 
      if [string match MF $yMn]  { set yMn $tHx } 
      if [string match MF $xMx]  { set xMx $pHy } 
      if [string match MF $yMx]  { set yMx $tHy } 


      if [string match X $aX] {
         set rV [TUgridCut pG pI $xMn $yMn $xMx $yMx $nP _X_ _Y_ _V_]
         set ExC [list < -1.0e30 <= 0.0]
         set EnD [expr [lindex $rV 0] - 1]
         PLTlinePlot $pN Xb Yr _X_ _V_ Dum Dum 0 $EnD [list 2D $lC] $ExC
      } else {
         set rV [TUgridCut pG pI $xMn $yMn $xMx $yMx $nP _X_ _Y_ _V_]
         set ExC [list <= 0.0 < -1.0e30]
         set EnD [expr [lindex $rV 0] - 1]
         PLTlinePlot $pN Xt Yl _V_ _Y_ Dum Dum 0 $EnD [list 2D $lC] $ExC
      }

#     set EnD [expr [lindex $rV 0] - 1]
#     PLTlinePlot $pN Xt Yr _X_ _V_ Dum Dum 0 $EnD [list 2D $lC] $ExC

      if [string match SHOW $sL] {
         PlotColor HOLD $lC OFF
         LineStyle $lW SPDASH1
	 set Xa [lindex $rV 1] 
	 set Ya [lindex $rV 2] 
	 set Xb [lindex $rV 3] 
	 set Yb [lindex $rV 4] 
	 Line $pN $Xa $Ya 0. $Xb $Yb 0.
      }
   }

   LineStyle 1 SOLID

   update
}
