# THIS removes a region in phase space which may have bad or comtaminated
#    data.  The region is defined by limits in E, phi, and theta.  The
#    removed region is refilled using a linear interpolation in phi.

package provide ptPlots 1.0

proc PTclipData { sN Data Phase} {
   global ptANS thBImG thEImG eEImG eBImG

   upvar $Phase phImG
   upvar $Data  dImG

   set sID $ptANS($sN,sID)

# THIS is the text window for clipping and masking

   set W .ptMask.body.list
   if ![winfo exists $W] { PTguiMasks 1 }

# THIS is the number of definition in the window

   set nF [$W index end]

# THE image sizes

   set tS  [expr $ptANS($sID,NSEN) * $ptANS($sN,nE)]
   set ToT [expr $tS * $ptANS($sN,Sector)]

# LOOP over the definitions and process the clipping ones

   for { set Q 0 } { $Q < $nF } { incr Q } { 

# READ the line

      set LiNe [$W get $Q]
      scan $LiNe "%s %f %f %f %f %f %f %f" Type eBeg eEnd pBeg pEnd tBeg tEnd pM

      set cA [string match CLIP_A $Type] 
      set cR [string match CLIP_R $Type] 

      if { !$cA && !$cR } { continue }

      set pBeg [expr fmod(($pBeg + $ptANS(pLook)), 360.0)]
      set pEnd [expr fmod(($pEnd + $ptANS(pLook)), 360.0)]

# COMPUTE masks for the phi, velocity and theta arrays.

# ENERGY clipping is either ABSOLUTE or RELATIVE.  RELATIVE clipping is
#   done using the potential corrected energies.  For this we use the
#   velocity array.  Otherwise we use the read in energies.

      set vB $eBeg
      set vE $eEnd

      if { $eBImG($sN,0) < $eEImG($sN,0) } { 
         upvar 0 eBImG V1 ; upvar 0 eEImG V2
      } else { upvar 0 eBImG V2 ; upvar 0 eEImG V1 }

      for { set I 0 } { $I < $ptANS($sN,nE) } { incr I } {
         if { ($vB <= $V1($sN,$I)) && ($vE >= $V2($sN,$I)) } {
            set vMask($I) 1
         } else { set vMask($I) 0 }
      }

# THETA - array is in radians so limits need to be also 

      set tB $tBeg
      set tE $tEnd

      if { $thBImG($sN,0) < $thEImG($sN,0) } { 
         upvar 0 thBImG V1 ; upvar 0 thEImG V2
      } else { upvar 0 thBImG V2 ; upvar 0 thEImG V1 }

      for { set I 0 } { $I < $ptANS($sID,NSEN) } { incr I } {
         if { ($tB <= $V1($sN,$I)) && ($tE >= $V2($sN,$I)) } {
            set tMask($I) 1
         } else { set tMask($I) 0 }
      }

# PHASE - array is in degrees before any offset subtraction 

      set pB $pBeg
      set pE $pEnd
      set nP [expr $ptANS($sN,nE) * $ptANS($sN,Sector)]

      if { $pE >= $pB } { 
         for { set I 0 } { $I < $nP } { incr I } {
           if { ($phImG($I) > $pB) && ($phImG($I) < $pE) } {
               set pMask($I) 1
            } else { set pMask($I) 0 }
         }
      } else {
         for { set I 0 } { $I < $nP } { incr I } {
           if { ($phImG($I) > $pB) || ($phImG($I) < $pE) } {
               set pMask($I) 1
            } else { set pMask($I) 0 }
         }
      }

# NOW the fun part.  

# IF we are clipping out a part of the distribution then Set each 
#    measurement in the df array which is in the region begin clipped to -1.  

      if { $pM < 0.0 } {
         set N 0
         for { set I 0 } { $I < $ptANS($sN,Sector) } { incr I } {
            for { set J 0 } { $J < $ptANS($sID,NSEN) } { incr J } {
               set L [expr $I * $ptANS($sN,nE)]
               for { set K 0 } { $K < $ptANS($sN,nE) } { incr K ; incr L ; incr N } {
	          if { $pMask($L) && $vMask($K) && $tMask($J) } { 
	               set dImG($N) -1.0 
	          }
	       }
            }
         }
      } else {
         set pC $pM

# WE are removing all data above some percentage of the min or max value
#   within all phases at a fixed energy/elevation.  This is used to remove
#   charging features.

         for { set I 0 } { $I < $ptANS($sID,NSEN) } { incr I } {
            if $tMask($I) { 
               for { set J 0 } { $J < $ptANS($sN,nE) } { incr J } {
	          if $vMask($J) { 
                     set MaX -100.0
                     set MiN  1.0e31
                     set N [expr $I * $ptANS($sN,nE) + $J]
                     for { set K 0 } { $K < $ptANS($sN,Sector) } { incr K } {
	                if { $dImG($N) > $MaX } { set MaX $dImG($N) }
	                if { $dImG($N) < $MiN } { set MiN $dImG($N) }
	                incr N $tS
                     }
		     if { $MaX > 0.0 } { 
	                set lMx [expr log($MaX)]
		        if { $MiN > 0.0 } { 
		            set lMn [expr log($MiN)]
	                    set RmV [expr exp($lMx - ($lMx - $lMn) * $pC)]
                        } else { set RmV [expr $MaX * $pC] } 
                        set N [expr $I * $ptANS($sN,nE) + $J]
                        for { set K 0 } { $K < $ptANS($sN,Sector) } { incr K } {
	                   if { $dImG($N) > $RmV } { set dImG($N) -1.0 }
	                   incr N $tS
                        }
                     }
                  }
               }
            }
         }
      }

# NOW get rid of the -1's by linearly interpolating in phi across the gaps
#   Do this sensor by sensor and within each sensor energy step by energy
#   step

      set tS  [expr $ptANS($sID,NSEN) * $ptANS($sN,nE)]
      set ToT [expr $tS * $ptANS($sN,Sector)]
      set LastS [expr $ptANS($sN,Sector) -1 ]

      for { set I 0 } { $I < $tS } { incr I } {
         set EnD $ptANS($sN,Sector)
         set J 0
         set K $I

# FIND the first filled sector for this energy/sensor

         while { ($dImG($K) < 0.0) && ($J < $ptANS($sN,Sector)) } { 
	    incr EnD 
	    incr J
	    incr K $tS
            set K [expr $K % $ToT]
         }

# IF there are none do nothing - probably should set them all to 0

         if { $J == $LastS } {
            set K $I
            for { set J 0 } { $J <= $LastS } { incr J ; incr K $tS } {
	       set $dImG($K) 0.0
	    }
         } else {

# NOW loop over a full spin beginning with the first filled sector

            set L [expr $K % $ToT]
	    set bG $L
            while { $J < $EnD } {
               set gL 0

# CHECK for a gap and get its length if one exists

               while { ($dImG($L) < 0.0) && ($J < $EnD) } { 
	          incr J 
	          incr K $tS 
	          set L [expr $K % $ToT]
	          incr gL
	       }

# IF there was a gap then fill it

               if { $gL > 0 } {
	          set M [expr $bG + $tS] 
	          if { ($dImG($L) > 0.0) && ($dImG($bG) > 0.0) } {
	             set A [expr (log10($dImG($L) / $dImG($bG)))/($gL + 1.0)]
	             set Base [expr log10($dImG($bG))]
	             for { set N 1 } { $N <= $gL } { incr N ; incr M $tS } {
	                set Q [expr $M % $ToT]
		        set dImG($Q) [expr pow(10., ($Base + double($N) * $A))]
	             }
                  } else {
	             if { ($dImG($L) <= 0.0) && ($dImG($bG) <= 0.0) } {
	                set Base 0.0
                     } elseif { $dImG($L) <= 0.0 } {
	                set Base [expr 0.5 * $dImG($bG)]
                     } else { set Base [expr 0.5 * $dImG($L)] }
	             for { set N 1 } { $N <= $gL } { incr N ; incr M $tS } {
	                set Q [expr $M % $ToT]
		        set dImG($Q) $Base 
	             }
                  }
	       } else { 
	          set bG $L
	          incr J 
	          incr K $tS
	          set L [expr $K % $ToT]
               }
            }
         }
      }
   }
}
