#  Variable initialization routine

package provide ptPlots 1.0

proc PTallInits { Type { sN 0 } } {
   global ptANS GphInfo Prefs

   switch -exact -- $Type {
      PREMENU {
         set ptANS(VARIABLE,lf) " %-4s %-10s %-12s %-12s %-12s %-12s"
         set ptANS(MaskslfA) "%19s %14s %14s"
         set ptANS(MASKS,lf) " %-8s %-8s %-8s %-6s %-6s %-6s %-6s %-5s %-5s"
         set ptANS(CUTS,lf) " %-10s %-10s %-10s %-10s %-10s %-4s %-5s %-5s"
	 set ptANS(sItems) [list VARIABLE]
	 set ptANS(sWin) [list .ptVAR.body.list]
	 set ptANS(sId) [list sType]
	 set ptANS(fItems) [list MASKS CUTS]
	 set ptANS(fWin) [list .ptMask.body.list .ptCuts.body.list]
	 set ptANS(CURsType) NONE
	 set ptANS(EmptyVar) ---
	 set ptANS(FrGap) 2.0
	 set ptANS(Bad) -1.0e31
	 set ptANS(VpVp) 0
	 set ptANS(uLab) ""
	 set ptANS(ScTs) 12
	 set ptANS(TmTs) 12
	 set ptANS(tDir) HOR
	 set ptANS(PSrc) ""
	 set ptANS(AreCuts) 0
	 set ptANS(CutLoc) ""


         set ptANS(COSYS) [list CARTESIAN LAMBERT_CYLINDRICAL \
                          BEHRMANN_CYLINDRICAL TRISTAN_EDWARDS PETERS \
                          GALL_ORTHOGRAPHIC BALTHASART EQUIRECTANGULAR \
                          MILLER37 MILLER43 MILLER50 CYLINDRICAL \
                          CYLINDRICAL_EQUAL_AREA CYLINDRICAL_EQUIDISTANT \
                          ECKERT_SINUSOIDAL ECKERT_ELLIPSOIDAL MERCATOR \
                          MOLLWEIDE ORTHOGRAPHIC SINUSOIDAL STEREOGRAPHIC \
			  VPAVPR_C VPAVPR_P  VPRVPR_C VPRVPR_P ]


	 set ptANS(Mass) 9.11e-31        
	 set ptANS(Q) 1.602e-19
	 set ptANS(toV) [expr 2.0 * $ptANS(Q) / $ptANS(Mass)]
	 set ptANS(vF) CENTERS

	 set ptANS(State) START

	 set GphInfo(ACTIVE) PTactiveButton
	 set GphInfo(CLOSE) PTcloseButton

# READ in any user configuration parameters

         TUreadUDFrc PTplots MoPs
         if [info exists MoPs(FontFit)] {
            set Prefs(bFit) $MoPs(FontFit)
         } else { set Prefs(bFit) 0 }

	 if [info exists MoPs(VIDFPr)] {
	    set ptANS(VIDFPr) $MoPs(VIDFPr)
	 } else { set ptANS(VIDFPr) NONE }

         UDFInits $ptANS(VIDFPr)
      }

      COR -
      COORD -
      FIT -
      LABELS -
      MASKS -
      PSET -
      CUTS -
      PSCRIPT -
      TIME {
         set nV [PTvarList $Type vL $sN]
         for { set I 0 } { $I < $nV } { incr I } {
	    set vI [lindex $vL $I]
	    set vN [lindex $vI 0]
	    set vS [lindex $vI 1]
            if ![info exists ptANS($vN)] { set ptANS($vN) $vS }
         }
      }

      default {
         set nV [PTvarList $Type vL $sN]
         for { set J 0 } { $J < $nV } { incr J } {
	    set vI [lindex $vL $J]
	    set vN $sN,[lindex $vI 0]
	    set vS [lindex $vI 1]
            if ![info exists ptANS($vN)] { set ptANS($vN) $vS }
         }
      }
   }
}
