# ADD MF data to the plot

package provide ptPlots 1.0

proc PTaddMF { Row Col } {
   global ptANS GphInfo RtoD GSEtoSC mfInfo

# IF there isn't any MF data then no reason to go any further

   if { !$ptANS(MF,ok) || [string match NO $ptANS(pMF)] } { return }

   if [string match NO $ptANS(hrMF)] {
      set Sets 1
   } else { set Sets $ptANS(nMFhrs) }

   SetCorSys $ptANS(tCoSyS) $ptANS(csInfo)

   set pN [expr $Row + $ptANS(nRow) * $Col]
   GPHwinScale $pN Xp Yp Zc 0

   set tS $GphInfo(tSize)


   set nS 0
   for { set I 0 } { $I < $Sets } { incr I } {

      set vA $nS; incr nS
      set vB $nS; incr nS
      set vC $nS; incr nS
      set vD $nS; incr nS

      TextProp $ptANS(MfHS) HOLD ON
      set SyM [PTucodeParse $ptANS(MfHSym)]
      if $ptANS(MfHac) { set C $mfInfo(colorA) } else { set C $ptANS(MfHC) }
      TexT $pN $mfInfo($vA) $mfInfo($vB) 0.0 center $SyM $C

      TextProp $ptANS(MfTS) HOLD ON
      set SyM [PTucodeParse $ptANS(MfTSym)]
      if $ptANS(MfTac) { set C $mfInfo(colorB) } else { set C $ptANS(MfHC) }
      TexT $pN $mfInfo($vC) $mfInfo($vD) 0.0 center $SyM $C
   }

   TextProp $tS HOLD OFF
   SetCorSys CARTESIAN [list 0.0 0.0 0.0]

   update
}
