# THIS procedure acquires the measurements from a single source during
#   the duration of one of the moments computation.

# IN the procedure:
#   tChk == 0 : measurement time is earlier than the time of the moments
#   tChk == 1 : measurement time is within than the time of the moments
#   tChk == 2 : measurement time is later than the time of the moments

package provide ptPlots 1.0

proc PTacqUDF { psN S rV } {
   global SInfo ptANS ExDa 

   upvar $rV V

# IF we have hit the end of file for this data then return no values
#   and let the calling routine determine what to do

   if $ptANS($S,EOF) { return 0 }

# THIS is the number of sensors being processed under this definition

   set nS [llength $ptANS($S,sNum)]

# THIS is the number of the last sensor

   set lS [expr $nS - 1]

# INITIALIZE the normalization and values for the sensors 

   for { set I 0 } { $I < $nS } { incr I } { 
      set Norm($I) 0.0 
      set V($I)  0.0 
   }
       
# CHECK to see where this sensor stands with respect to the time of the
#   current moment calculation

   if { $ptANS($S,tChk) > 1 } {
      set ptANS($S,tChk) [PTtimeCheck $psN $S Fr]
      if { ($ptANS($S,tChk) == 1) || ($ptANS($S,tChk) == 3) } { 
         for { set I 0 } { $I < $nS } { incr I } {
            set V($I) [expr $Fr * $ptANS($S,cV$I)] 
	    set Norm($I) $Fr
         }
      } 
   } 

# THIS is the acquisition loop.  Acquire the sensors so long as their 
#   center time is within the time of the moments computation.  Forward
#   on the last sensor


   set KeY  $ptANS($S,KeY)
   while { $ptANS($S,tChk) < 2 } { 
      for { set I 0 } { $I <= $lS } { incr I } {
         if { $I == $lS } { set FwD 1 } else { set FwD 0 }
	 set sN [lindex $ptANS($S,sNum) $I]
	 set uN [lindex $ptANS($S,sUnit) $I]
         set rS [ReadUDF $KeY 0 1 $sN 0 $FwD 0]
	 if { [lindex [split $rS "|"] 0] == -1 } { 
	     set ptANS($S,EOF) 1  
	     return 0
	 }
	 if { $I == 0 } { 
            set ptANS($S,bfYr) $ExDa(1,BYR)
	    set ptANS($S,efYr) $ExDa(1,EYR)
            set ptANS($S,bfDy) $ExDa(1,BDY)
	    set ptANS($S,efDy) $ExDa(1,EDY)
            set ptANS($S,bfMs) $ExDa(1,BMSEC)
	    set ptANS($S,efMs) $ExDa(1,EMSEC)
            set ptANS($S,tChk) [PTtimeCheck $psN $S Fr]
         }
         set ptANS($S,cV$I) [ConvertToUnits $KeY 0 1 $uN Data] 
         if { ($ptANS($S,tChk) == 1) || ($ptANS($S,tChk) == 3) } { 
            set V($I) [expr $V($I) + $Fr * $ptANS($S,cV$I)] 
	    set Norm($I) [expr $Norm($I) + $Fr]
         }
      }
   }

   if { $Norm(0) > 0 } {
      for { set I 0 } { $I < $nS } { incr I } { 
          set V($I) [expr $V($I) / $Norm($I)] 
      }
   } else {
      for { set I 0 } { $I < $nS } { incr I } { 
         set V($I) $ptANS(Bad)
      }
   }

   return $nS
}
