#  THIS procedure acquires the polar angles associated with each defined
#  PLOT source.

package provide ptPlots 1.0

proc PTacqTheta { } {
   global ptANS thBImG thEImG RtoD

   set nPS [llength $ptANS(PSrc)]

   for { set J 0 } { $J < $nPS } { incr J } {
      set sN [lindex $ptANS(PSrc) $J]

      set KeY $ptANS($sN,KeY)

# FILL in the theta angles.  The information comes from the VIDF.  
#   Loop over the defined constants.  We are looking for the fillowing:
#   cID = 1: Center elevation angles
#   cID = 4: Start elevation angles
#   cID = 5: Stop elevation angles
#   cID = 9: Elevation FWHM

      set iD1 0 ; set iD4 0 ; set iD5 0 ; set iD9 0
      ReadVIDF $KeY 0 NUMCONSTS 0 0 0 NConst
      for {set I 0} {$I < $NConst} { incr I } {
         ReadVIDF $KeY 0 CONSTID $I 0 0 cID
         switch -exact -- $cID {
            1   {  
               ReadVIDF $KeY 0 CONSTSCA $I 0 -1 Sc 1
               ReadVIDF $KeY 0 CONST $I 0 -1 V 1
               UDFScale Sc V CenTer 1
               set iD1 1
               unset Sc
               unset V
            }
            4   {  
               ReadVIDF $KeY 0 CONSTSCA $I 0 -1 Sc 1
               ReadVIDF $KeY 0 CONST $I 0 -1 V 1
               UDFScale Sc V LoW 1
               set iD4 1
               unset Sc
               unset V
            }
            5   {  
               ReadVIDF $KeY 0 CONSTSCA $I 0 -1 Sc 1
               ReadVIDF $KeY 0 CONST $I 0 -1 V 1
               UDFScale Sc V HigH 1
               set iD5 1
               unset Sc
               unset V
            }
            9   {  
               ReadVIDF $KeY 0 CONSTSCA $I 0 -1 Sc 1
               ReadVIDF $KeY 0 CONST $I 0 -1 V 1
               UDFScale Sc V FwHm 1
               set iD9 1
               unset Sc
               unset V
            }
         }
      }

# OK we have what information we are going to get now lets hope we have
#   enough to build the start/stop array.

      if { $iD4 && $iD5 } {
         set nS [array size LoW] 
         for { set I 0 } { $I < $nS } { incr I } {
            set thBImG($sN,$I) $LoW($I)
            set thEImG($sN,$I) $HigH($I)
         } 
      } elseif { $iD1 && $iD9 } {
         set nS [array size FwHm] 
         for { set I 0 } { $I < $nS } { incr I } {
            set dT [expr FwHM($I) / 2.0]
            set thBImG($sN,$I) [expr $CenTeR($I) - $dT]
            set thEImG($sN,$I) [expr $CenTeR($I) + $dT]
         } 
      } elseif { $iD4 && $iD9 } {
         set nS [array size FwHm] 
         for { set I 0 } { $I < $nS } { incr I } {
            set thBImG($sN,$I) $LoW($I)
            set thEImG($sN,$I) [expr $LoW($I) + $FwHm($I)]
         } 
      } elseif { $iD5 && $iD9 } {
         set nS [array size FwHm] 
         for { set I 0 } { $I < $nS } { incr I } {
            set thBImG($sN,$I) [expr $HigH($I) - $FwHm($I)]
            set thEImG($sN,$I) $HigH($I)
         } 
      } else {
         puts stderr "NO THETA INFORMATION"
         exit
      }

   # FLIP theta about 180 degrees if using a flow reference frame

      if [string match FLOW $ptANS(LookDir)] {
         for { set I 0 } { $I < $nS } { incr I } {
             set thBImG($sN,$I) [expr 180.0 - $thBImG($sN,$I)]
             set thEImG($sN,$I) [expr 180.0 - $thEImG($sN,$I)]
          }
      }
   }
}
