# THIS procedure puts up the plots
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTvpvpPPlot { sN Row Col ImG Elev Phase } {
   global ptANS pgI fgInfo cInputs GphInfo RtoD GSEtoSC eVC

   upvar $ImG   V
   upvar $Elev  E
   upvar $Phase P

   set sID $ptANS($sN,sID)

# THIS is the plot type

   set pType [string match VPAVPR_P $ptANS(CoSyS)]

# SMOOTHING factor

   if { $ptANS(Smooth) <= 0 } { set sM 1 } else { set sM $ptANS(Smooth) }

# DRIFT correction

   set Vd(0) $ptANS(Vdx)
   set Vd(1) $ptANS(Vdy)
   set Vd(2) $ptANS(Vdz)

# PLOT Grid

   set vgI(0)  0.0
   set vgI(1)  360.0
   set vgI(2)  $ptANS(vMiN)
   set vgI(3)  $ptANS(vMaX)
   set vgI(4)  $ptANS(xGs)
   set vgI(5)  $ptANS(yGs)
   set vgI(6)  POINT
   set vgI(7)  POINT
   set vgI(8)  COLUMN
   set vgI(9)  KEEP
   set vgI(10) NEW:ADD:END
   set vgI(11) 0.0
   set vgI(12) 1.0e31
   set vgI(13) -1.0e32
   set vgI(14) 1.0e32
   set vgI(15) YES
   set vgI(16) NO
   set vgI(17) LINEAR
   set vgI(18) LINEAR

# SET up the velocities needed to fill the plot box.  Essentially include
#   all velocities upto and including the first velocity which exceeds the
#   total diagonal velocity of the plot box.

   set pV [expr abs($ptANS($sN,PV0))]

   set vDiag [expr 2.0 * $ptANS(vMaX) * $ptANS(vMaX)]
   set eBin ""
   if { $eVC($sN,1) > $eVC($sN,0) } {
      for { set K 0 } { $K < $ptANS($sN,nE) } { incr K } {
         set tVel [expr ($eVC($sN,$K) - $pV + $ptANS(CPV)) * $ptANS(toV)]
	 if { $tVel < 0 } { continue }
	 lappend eBin $K
	 if { $tVel > $vDiag } { break }
      }
   }  else {
      set Start [expr $ptANS($sN,nE) - 1]
      for { set K $Start } { $K >= 0 } { incr K -1 } {
         set tVel [expr ($eVC($sN,$K) - $pV + $ptANS(CPV)) * $ptANS(toV)]
         if { $tVel < 0 } { continue }
         lappend eBin $K
         if { $tVel > $vDiag } { break }
      }
   }

   set nEs [llength $eBin]
   for { set K 0 } { $K < $nEs } { incr K } {
      set cE $eVC($sN,[lindex $eBin $K])
      set cV($K) [expr sqrt(($cE - $pV + $ptANS(CPV)) * $ptANS(toV))]
   }

# UPDATE the number of phase and elevation sectors used in the data grid.
 
   set fgInfo(4)  [expr int($ptANS($sN,Sector) * $sM)]
   set fgInfo(5)  [expr int($ptANS($sID,NSEN) * $sM)]

   set pN [expr $Row + $ptANS(nRow) * $Col]

# TAKE B from GSE to S/C Frame.  Do the same to the drift velocity if its
#   in GSE

   set B(0) $ptANS($sN,MF0)
   set B(1) $ptANS($sN,MF1)
   set B(2) $ptANS($sN,MF2)
   TUmatrixMath GSEtoSC * B TmP 3 3 3 1
   set B(0) $TmP(0)
   set B(1) $TmP(1)
   set B(2) $TmP(2)

# IF we are not in the plasma flow frame but in the instrument frame then
#   we need to reverse the sign of B and Vd.

   if ![string match FLOW $ptANS(LookDir)] { 
      for { set I 0 } { $I < 3 } { incr I } {
         set B($I)  [expr -$B($I)]
         set Vd($I) [expr -$Vd($I)]
      }
   }

# SET up a rotation matrix which will rotate the magnetic field vector for
#    this plot to the x axis.  It's stored in rM.

   set pH [expr atan2($B(1), $B(0)) * $RtoD]
   set pH [expr fmod(360.0 + $pH, 360.0)]
   set XY [expr sqrt($B(0) * $B(0) + $B(1) * $B(1))]
   set tH [expr atan2($B(2), $XY) * $RtoD]
   set tH [expr 90.0 - $tH]

   TUmatrixRot $pH 0.0 0.0 rZ Z
   TUmatrixRot [expr 90.0 - $tH] 0.0 0.0 rY Y
   TUmatrixMath rY * rZ rM 3 3 3 3

# GET the data energy step by energy step.  This come back in 

   set vMx -1.0
   set vMn 1.0e30

# THIS is the centers of the elevation and phase bins in the energy
#   grids

   TUgridInfo 32 fgInfo xP
   TUgridInfo 33 fgInfo yE

# LOOP through the energy steps and get the Phase/Elevation grid for
#   each energy step and processs it.

   set nP 0 
   set MinV 1.0e30

   for { set K 0 } { $K < $nEs } { incr K } {
      set eS [lindex $eBin $K]
      PTgetEv $sN $eS fgInfo V E P eGrid 

      for { set I 0 ; set nE 0 } { $I < $fgInfo(4) } { incr I } {
         set pH [expr $xP($I) / $RtoD]
         set cP [ expr cos($pH)]
         set sP [ expr sin($pH)]
         for { set J 0 } { $J < $fgInfo(5) } { incr J } {
            set tH [expr $yE($J) / $RtoD]
            set cT [ expr cos($tH)]

# THIS is the velocity in S/C coordinates

            set Vel(0) [ expr $cV($K) * $cP * $cT - $Vd(0)]
            set Vel(1) [ expr $cV($K) * $sP * $cT - $Vd(1)]
            set Vel(2) [ expr $cV($K) * sin($tH) - $Vd(2)]

# Velocity magnitude 

            set Vm [TUvecMath Vel MAG Vel Vel]
	    if { $Vm < $vMn } { set vMn $Vm }
	    if { $Vm > $vMx } { set vMx $Vm }

# ROTATE this velocity vector into the frame where B is along X

            TUmatrixMath rM * Vel rV 3 3 3 1

# IN this frame Vperp is along X and Vpara is Y and Z. We are either 
#   plotting Vperp vs Vpara or Vperp vs Vperp

            set Vprp [expr sqrt($rV(1) * $rV(1) + $rV(2) * $rV(2))]

            if $pType {
	       if { $rV(1) < 0.0 } { set Vprp [expr -$Vprp] }
               set pH [expr atan2($Vprp, $rV(0)) * $RtoD]
               set Y($nP) $Vm
            } else {
               set pH [expr atan2($rV(2), $rV(1)) * $RtoD]
               set Y($nP) $Vprp
	    }

	    if { $MinV > $Y($nP) } { set MinV $Y($nP) }
	    if { $pH < 0.0 } { set pH [expr 360.0 + $pH] }
            set X($nP) $pH
            set Z($nP) $eGrid($nE)
	    incr nP
	    incr nE
         }
      }
   }

   set vgI(2) [expr $vMn]
   set vgI(3) [expr $vMx]
#  if { $ptANS(pMax) < $vMx } {
#     set nV [expr -$vMx]
#     SetAxis $pN PRIMARY $nV $nV HOLD $vMx $vMx HOLD HOLD HOLD HOLD 1 
#  }

   TUdataGrid $nP 1 X X 1 Y Y Z vGrid vNorM vgI

   set OpS(0) 0.0
   set OpS(1) 1
   set EdGeS [TUgridTrim EDGES vGrid vNorM vgI OpS]

   set fInfo(0) 1
   set fInfo(1) [expr $sM * 2]
   set fInfo(2) 4
   set fInfo(3) 2
   set fInfo(4) 0
   set fInfo(5) 0
   set fInfo(6) [lindex $EdGeS 2]
   set fInfo(7) [lindex $EdGeS 3]
   set fInfo(8) 2.0
   set fInfo(9) 1
   TUgridFill2D vGrid vgI vNorM fInfo

# GET MAX/MIN values in plot 

   set TotG [expr $vgI(4) * $vgI(5)]
   set Pos [TUdataMxMn vGrid $TotG <> 1.0e-33]
   set mIdx [lindex $Pos 0]
   if { $mIdx >= 0 } {
      if $ptANS(AutoS) {
         if { $mIdx >= 0 } {
	    if ![string match NONE $ptANS(iMin)] {
	       set cInputs(pMIN) $ptANS(iMin)
            } else { set cInputs(pMIN) $vGrid($mIdx) }
            set cInputs(pMAX) $vGrid([lindex $Pos 1])
            if { $cInputs(pMIN) == $cInputs(pMAX) } {
               if { $cInputs(pMIN) == 0.0 } {
                  set cInputs(pMAX) 0.01  
	       } else { set cInputs(pMAX) [expr $cInputs(pMIN) * 1.01] }
	    }        
         }
      } else {
         set cInputs(pMIN) $ptANS(iMin)
         set cInputs(pMAX) $ptANS(iMax)
      }

      TUgridInfo 30 vgI Ph
      TUgridInfo 31 vgI Yy

      set pgI(PF) FLAT
#     set pgI(PF) ELEVATE

      SetCorSys $ptANS(tCoSyS) $ptANS(csInfo)
      PLTcolorMap $cInputs(pMIN) $cInputs(pMAX) $cInputs(pSCA) NO cMAP

      WinClip $pN ON
      set EnD [expr $vgI(5) - 1]
      for { set K $EnD } { $K >= 0 } { incr K -1 } {
         set R $Yy([expr $K + 1])
	 TUgridRowCol vGrid vgI dF RETRIEVE ROW $K
         for { set I 0 ; set J 1 } { $I < $vgI(4) } { incr I ; incr J } {
            set A1 $Ph($I)
	    set J [expr $J % $vgI(4)]
            set A2 $Ph($J)
            if { $cMAP(4) == 1 } {
               if {$dF($I) > 0.0 } {
                  set C [expr int($cMAP(0) * log10($dF($I)) + $cMAP(1))]
               } else { set C -1 }
            } else { set C [expr int($cMAP(0) * $dF($I) + $cMAP(1))] }
            if { $C > $cMAP(3) } { set C $cMAP(3) }
            PlotColor HOLD $C $C
            Arc $pN 0. 0. 0. $R $A1 $A2 1 1 1.0
         }
      }

      PlotColor HOLD $GphInfo(bColor) $GphInfo(bColor)
      Arc $pN 0. 0. 0. $MinV 0.0 360.0 1 0 1.0
      PlotColor HOLD HOLD OFF
      WinClip $pN OFF
   } else {
      set cInputs(pMIN) ""
      set cInputs(pMAX) ""
   }

   PTplotEnd $sN $pN $Row $Col

   update
}
