# THIS procedure resets the variable menu items 

package provide ptPlots 1.0

proc PTresetMenu { } {
   global ptANS 

# SET up some initial lists of variables

   set PmEiV [list P M E I V] 
   set wID [list project mission exper inst vinst]

# THESE are basic commands which will wither be used or appended to
 
   set oC DBudfLineage
   set uC "GUudfOpts .ptUDF.src ptANS 0 $ptANS(dW) $ptANS(cW) $ptANS(fW)"
   set pC "GUpidfOpts $ptANS(dW) ptANS 0 "

# REESTABLISH the udf options

   set UdF ""
   for { set I 0 } { $I < 5 } { incr I } {
      set iD [lindex $PmEiV $I]
      set W  .ptUDF.src.[lindex $wID $I]
      if { [string length $ptANS(0,$iD)] > 0 } {
         set oPC "set oPs \[$oC\]"
         eval $oPC
         set CmD "$uC $iD $ptANS(mF) "
         GUImenuFill $W $oPs $CmD NEW 0 $ptANS(mF)
         lappend oC $ptANS(0,$iD)
         lappend UdF $ptANS(0,$iD)
      } else { break }
   }

# REESTABLISH the measurement options.  Process stops when a measurement
#   option is hit which is not detined. 

# GROUP option

   if { [string length $ptANS(0,V)] > 0 } {
      set Wp $ptANS(dW).src
      set pOp [GUpidfLists $UdF DataSource DUMMY]
      set npC "$pC src $ptANS(dW) $ptANS(cW) $ptANS(fW) $ptANS(mF) "
      GUImenuFill $Wp $pOp $npC  NEW 0 $ptANS(mF)
   } else { return }

# MEASUREMENT definition.  This includes checking the measurement tyme and
#   if its matrix enabling the matrix column option.

   if { [string length $ptANS(0,srcP)] > 0 } {
      set Wp $ptANS(dW).mea
      if [string match A0 $ptANS(0,srcA)] {
         set SrC Ancillary
      } elseif [string match A1 $ptANS(0,srcA)] {
         set SrC Modes
      } else { set SrC Sensors }

      set Deps(0) $ptANS(0,meaA)
      set pOp [GUpidfLists $UdF $SrC Deps ]
      set npC "$pC mea $ptANS(dW) $ptANS(cW) $ptANS(fW) $ptANS(mF) "
      GUImenuFill $Wp $pOp $pC  NEW 0 $ptANS(mF)

      if { [string match Sensors $SrC] } {
         if { $ptANS(0,SenType) == "M" } { GUIstateSet $Wp.col REPLY normal }
      }
   } else { return }

# MEASUREMENT UNITS.  This depends on what's been selected.  This is either
#   a direct measurement (sensor, ancillary, mode) or the spin angle pitch
#   angle or quality flag. Only sensor and ancillary units can have units 
#   associated the array indices.

   if { $ptANS(0,extra) == 0 } {
      if { [string length $ptANS(0,meaP)] > 0 } {
         set Deps(0) $ptANS(0,srcA)
         set Deps(1) $ptANS(0,meaA)
         set Wp $ptANS(dW).mun
         set pOp [GUpidfLists $UdF Munits Deps]
         set npC "$pC mun $ptANS(dW) $ptANS(cW) $ptANS(fW) $ptANS(mF) "
         GUImenuFill $Wp $pOp $npC  NEW 0 $ptANS(mF)
         if { $ptANS(0,iuFlg) >= 0 } {
            set Wp $ptANS(dW).iun
            set Deps(0) $ptANS(0,iuFlg)
            set pOp [GUpidfLists $UdF Iunits Deps]
            set npC "$pC iun $ptANS(dW) $ptANS(cW) $ptANS(fW) $ptANS(mF) "
            GUImenuFill $Wp $pOp $npC  NEW 0 $ptANS(mF)
         }
      } else { return }
   } elseif { $ptANS(0,extra) == 1 } {
      set pOp [GUpidfLists $UdF Qunits DUMMY]
      GUImenuFill $Wp $pOp $pC  NEW 0 $ptANS(mF)
   } elseif { $ptANS(0,extra) == 2 } {
      set pOp [GUpidfLists $UdF Sunits DUMMY]
      GUImenuFill $Wp $pOp $pC  NEW 0 $ptANS(mF)
   } elseif { $ptANS(0,extra) == 3 } {
      set pOp [GUpidfLists $UdF Punits DUMMY]
      GUImenuFill $Wp $pOp $pC  NEW 0 $ptANS(mF)
   }
}
