# THIS procedure computes a number of quantites which need to be set once
#    the menu phase is complete and the plotting phase is to begin.

package provide ptPlots 1.0

proc PTpreCalcs { } {
   global ptANS GphInfo WinInfo GSEtoSC

   set nPS [llength $ptANS(PSrc)]

# IF there is no drift

   if { [string length $ptANS(Vdx)] == 0 } { set ptANS(Vdx) 0.0 }
   if { [string length $ptANS(Vdy)] == 0 } { set ptANS(Vdy) 0.0 }
   if { [string length $ptANS(Vdz)] == 0 } { set ptANS(Vdz) 0.0 }

   for { set I 0 } { $I < $nPS } { incr I } {
      set ptANS([lindex $ptANS(PSrc) $I],V0) $ptANS(Vdx)
      set ptANS([lindex $ptANS(PSrc) $I],V1) $ptANS(Vdy) 
      set ptANS([lindex $ptANS(PSrc) $I],V2) $ptANS(Vdz) 
   }

# IF the drift velocity is being returned dynamically its GSE

   if { [llength $ptANS(VELOCITY)] > 0 } { 
      set ptANS(vdFrm) GSE 
      set ptANS(fromSrc) 1
   } else { set ptANS(fromSrc) 0 }

# Check to see if there are any defined Cuts through the plots 
 
   set W .ptCuts.body.list
   if ![winfo exists $W] { PTguiCuts 1 }
   set nF [$W index end]
   if { $nF > 0 } { 
      set ptANS(AreCuts) 1 
      for { set I 0 } { $I < $nF } { incr I } {
         set LiNe [$W get $I]
         scan $LiNe "%s %s %s %s %s %s %s %s" xMn yMn xMx yMx lC lW sL aX
	 append ptANS(CutLoc) $aX
      }
   }

# SET spacecraft potential - its set per plot source

   if { [string length $ptANS(PV)] == 0 }  { 
      set cP 0.0
       set ptANS(CPV) -1.5
   } else { set cP $ptANS(PV) ; set ptANS(CPV) 0.0 }

   for { set I 0 } { $I < $nPS } { incr I } {
      set ptANS([lindex $ptANS(PSrc) $I],PV0) 0.0 
   }

# PUT the drift into the instrument flow frame of reference
#  if [string match GSE $ptANS(vdFrm)] { 
#     set Vd(0) $ptANS(Vdx)
#     set Vd(1) $ptANS(Vdy)
#     set Vd(2) $ptANS(Vdz)
#     TUmatrixMath GSEtoSC * Vd TmP 3 3 3 1
#     set ptANS(VdxIF) $TmP(0)
#     set ptANS(VdyIF) $TmP(1)
#     set ptANS(VdzIF) $TmP(2)
#  } else {
#     set ptANS(VdxIF) $ptANS(Vdx)
#     set ptANS(VdyIF) $ptANS(Vdy)
#     set ptANS(VdzIF) $ptANS(Vdz)
#  }

# Need to define a temporary coordinate system variable so we don't
#   destroy the original.  The temporary is used everywhere in the
#   processing.

      set ptANS(tCoSyS) $ptANS(CoSyS)

# SEE if we need a colorbar or are we auto scaling.  As long as the requested
#   min and max scaling are not equal and both not NONE then do not autoscale.

   set MiN [string match NONE $ptANS(iMin)] 
   set MaX [string match NONE $ptANS(iMax)] 

   if { !$MiN && !$MaX } { 
      if { $ptANS(iMin) == $ptANS(iMax) } {
         set ptANS(cB) 0 ; set ptANS(AutoS) 1 
      } else { set ptANS(cB) 1 ; set ptANS(AutoS) 0 }
   } else { set ptANS(cB) 0 ; set ptANS(AutoS) 1 }

# SEE if either the MF source is defined and are we using it.

   if { [llength $ptANS(MAGFIELD)] > 0 } { 
      set ptANS(MF,ok) 1 
   } else { set ptANS(MF,ok) 0 } 

# SET the number of spins to skip.  For the user skip 0 is no spins skipped
#   but the code wants to see 1 (skip to the next spin)

   set SkiP [expr $ptANS(SpinSkip) + 1] 

# SET the phi and theta look direction offsets used to change between the
#  instrument and flow look directions.

   if [string match INST $ptANS(LookDir)] {
      set ptANS(pLook) 0.0
      set ptANS(tLook) 1.0
   } else { set ptANS(pLook) 180.0 ; set ptANS(tLook) -1.0 }

# NOW do the projection dependent parameters.  Give them all defaults
#   and then change any that need to be varied

   set ptANS(pMin) -180.0
   set ptANS(pMax)  180.0
   set ptANS(tMin)  -90.0
   set ptANS(tMax)   90.0
   set ptANS(MinPhi) -180.0
   set ptANS(MaxPhi)  180.0
   set ptANS(MinElev)   -90.0
   set ptANS(MaxElev)    90.0
   set ptANS(XTics) 6
   set ptANS(YTics) 6
   set ptANS(XYRatio) 2.0
   set ptANS(csInfo) [list 0.0 0.0 0.0]
   set ptANS(AxisNums) AUTO 
   set ptANS(AxisLabs) YES 

   switch -exact -- $ptANS(tCoSyS) {
      CARTESIAN {
         set ptANS(pMax) [expr 180.0 + $ptANS(cPhi)] 
         if { $ptANS(pMax) > 360.0 } { 
            set ptANS(pMax) [expr fmod($ptANS(pMax),360.0)]
         }
         set ptANS(pMin) [expr $ptANS(pMax) - 360.0] 

         set ptANS(MinPhi) $ptANS(pMin)
         set ptANS(MaxPhi) $ptANS(pMax)
         set ptANS(XTics) [expr int (360.0 / $ptANS(dPhi))]
         set ptANS(YTics) [expr int (180.0 / $ptANS(dElev))]
      }
      ORTHOGRAPHIC {
         set ptANS(XYRatio) 1.0
         set ptANS(pMin) -1.0
         set ptANS(pMax)  1.0
         set ptANS(tMin) -1.0
         set ptANS(tMax)  1.0
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
	 set ptANS(AxisNums) NONE 
      }
      CYLINDRICAL_EQUIDISTANT -
      EQUIRECTANGULAR {
         set ptANS(XYRatio) 2.0
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
      }
      MOLLWEIDE -
      ECKERT_SINUSOIDAL -
      SINUSOIDAL {
         set ptANS(XYRatio) 2.0
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
	 set ptANS(AxisNums) NONE 
      }
      ECKERT_ELLIPSOIDAL {
         set ptANS(XYRatio) 1.0
         set ptANS(pMin) -90.0
         set ptANS(pMax)  90.0
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
	 set ptANS(AxisNums) NONE 
      }
      CYLINDRICAL_EQUAL_AREA -
      LAMBERT_CYLINDRICAL {
         set ptANS(XYRatio) 2.0
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(tMin) -1.0
         set ptANS(tMax)  1.0
      }
      BEHRMANN_CYLINDRICAL {
         set ptANS(XYRatio) 1.73
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(pMin) -155.88
         set ptANS(pMax)  155.88
         set ptANS(tMin) -1.15
         set ptANS(tMax)  1.15
      }
      TRISTAN_EDWARDS {
         set ptANS(XYRatio) 1.589
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(pMin) -143.03
         set ptANS(pMax)  143.03
         set ptANS(tMin) -1.26
         set ptANS(tMax)  1.26
      }
      PETERS {
         set ptANS(XYRatio) 1.435
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(pMin) -129.18
         set ptANS(pMax)  129.18
         set ptANS(tMin) -1.39
         set ptANS(tMax)  1.39
      }
      GALL_ORTHOGRAPHIC {
         set ptANS(XYRatio) 1.414
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(pMin) -127.28
         set ptANS(pMax)  127.28
         set ptANS(tMin) -1.41
         set ptANS(tMax)  1.41
      }
      BALTHASART {
         set ptANS(XYRatio) 1.2856
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(pMin) -115.70
         set ptANS(pMax)  115.70
         set ptANS(tMin) -1.56
         set ptANS(tMax)  1.56
      }
      MILLER37 {
         set ptANS(XYRatio) 1.587
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(pMin) -142.80
         set ptANS(pMax)  142.80
      }
      MILLER43 {
         set ptANS(XYRatio) 1.463
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(pMin) -131.64
         set ptANS(pMax)  131.64
      }
      MILLER50 {
         set ptANS(XYRatio) 1.273
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(pMin) -114.57
         set ptANS(pMax)  114.57
      }
      CYLINDRICAL {
         set ptANS(XYRatio) 2.57
         set ptANS(MinElev) -70.0
         set ptANS(MaxElev)  70.0
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(tMin) -2.75
         set ptANS(tMax)  2.75
      }
      MERCATOR {
         set ptANS(XYRatio) 2.25
         set ptANS(MinElev) -80.0
         set ptANS(MaxElev)  80.0
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(tMin) -2.44
         set ptANS(tMax)  2.44
      }
      STEREOGRAPHIC {
         set ptANS(XYRatio) 2.0
         set ptANS(pMin) -4.6
         set ptANS(pMax)  4.6
         set ptANS(tMin) -2.3
         set ptANS(tMax)  2.3
	 set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) $ptANS(pRad)]
	 set ptANS(AxisNums) NONE 
	 set ptANS(AxisLabs) NONE 
      }
      VPRVPR_C - 
      VPRVPR_P - 
      VPAVPR_C - 
      VPAVPR_P {
         set ptANS(VpVp) 1
         set ptANS(XYRatio) 1.0
         set ptANS(pMin) -1.0
         set ptANS(pMax)  1.0
         set ptANS(tMin) -1.0
         set ptANS(tMax)  1.0
         set ptANS(csInfo) [list $ptANS(cPhi) $ptANS(cElev) 0.0]
         set ptANS(tCoSyS) CARTESIAN
      }
   }
}
