# THIS procedure sets up the PT plot graphics. There are a number of different
#   formats which can be used.  These are described below
#
# ONE DATA SOURCE (multiple energies)
#    1. Nominal - energies from a single spin go down column. Single label
#       above each plot showing the autoscaling range.  Energy of each
#       row of plots is shown to right of last plot in row.
#    2. Nominal varient - uses fixed scaling for all plots so no labels
#       above plots but colorbar is output.
# ONE DATA SOURCE (one energy)
#    1. Nominal - plots run horizontal with the number of rows of plots
#       given in the Min Row/Col option in SetUp page. Two labels above
#       each plot time and scaling.  Energy added to main label.
#    2. Nominal varient - uses fixed scaling for all plots so only time label
#       above plots and colorbar is output.
#    3. Nominal and nominal varient output vertically by setting the time
#       flow option to VER.  All labeling options are the same.

package provide ptPlots 1.0

proc PTplotSetUp { } {
   global ptANS GphInfo WinInfo DevInfo

   set nPS [llength $ptANS(PSrc)]
   set tF  [string match VER $ptANS(tDir)]

# THIS is the screen area we get to work within

   set  GphInfo(xScrL) $ptANS(xPix)
   set  GphInfo(yScrL) $ptANS(yPix)

# FIRE up the graphics if not already running.  If it is just clear the
#    window

   if [info exists GphInfo(CurScr)]  {
      if [winfo exists $DevInfo(Scr$GphInfo(CurScr))] {
         ClearWindow A
      } else { GraphicsOn TK $ptANS(ctbl) SWAP }
   } else { GraphicsOn TK $ptANS(ctbl) SWAP }

# DO initialization of background and foreground colors

   BackGround #fffffe 1
   PlotColor HOLD $GphInfo(bColor) OFF

# SET up background window

   set xS [expr $GphInfo(xScrL) - 1]
   set yS [expr $GphInfo(yScrL) - 1]

   GenWindow A 0.0 0.0 0.0 1.0 1.0 0.0 0. 0. 0. $xS $yS 0.

# INITIALIZE text properties and get text size in background window

   TextProp 12
   set ptANS(BcS) [GPHtextLen A XY]
   set cSX [lindex $ptANS(BcS) 0]
   set cSY [lindex $ptANS(BcS) 1]
   set pGx [expr 1.5 * $cSY] 

# THIS is how much room the plots have to occupy after accounting for top
#   and bottom dedicated labels including the colorbar if one is output.

  
   if { ($nPS > 1) && ( $tF || ($ptANS(eRow) > 1)) } {
      set yTop  [expr $yS - 11.0 * $cSY]
   } else { set yTop   [expr $yS - 9 * $cSY] }

   if  $ptANS(cB) {
      set yBot   [expr 12 * $cSY]
   } else { set yBot   [expr 5 * $cSY] }

# IF there is a cut beging displayed then we need to add more room to
#    the right of the plots
 
   if  $ptANS(AreCuts) {
      set xRight [expr 7 * $cSX]
   } else { set xRight 0.0 }


# SET up the y gap between succesive plots down a column.  How big this
#   gap should be will depend on the type of plot.

# VperpVpara plots. These plots  have two labels between the plots
#   (scaling and time) unless there is a colorbar and then there is only one.

   set ptANS(gLab) 1
   if $ptANS(VpVp) {
      if !$ptANS(cB) {
         set pGy [expr 3.0 * $cSY] 
	 set ptANS(gLab) 2
      } else { set pGy [expr 1.75 * $cSY] }
      set xLeft  [expr 10 * $cSX]
      set xRight [expr $xS - 4 * $cSX - $xRight]
   } else {

# Fixed energy plots.  These plots have two labels between the plots 
#  (scaling and time) if there is only one energy, one label if more than 
#  one energy (scaling) and no lablels if there is a colorbar being displayed.

      if !$ptANS(cB) {
         if { $ptANS(eRow) == 1 } { 
            set pGy [expr 3.0 * $cSY] 
	    set ptANS(gLab) 2
         } else { set pGy [expr 1.5 * $cSY] } 
      } else { set pGy [expr 0.4 * $cSY] ; set ptANS(gLab) 0 }
      set xLeft  [expr 6 * $cSX]
      set xRight [expr $xS - 8 * $cSX]
   }

#  Now get the space that will allow the correct number of rows and columns
#   of plots to be output

   set rV [PTplotSize $yTop $yBot $xRight $xLeft $pGx $pGy] 
   set dX [lindex $rV 0]
   set dY [lindex $rV 1]

   set lC [expr $ptANS(nCol) - 1]

   set ptANS(pXL) $dX
   set ptANS(pYL) $dY
   set ptANS(pXG) $pGx
   set ptANS(pYG) $pGy

   set pN 0
   for { set J 0 } { $J < $ptANS(nCol) } { incr J } {
      set xL [expr $xLeft + $J * ($dX + $pGx)]
      set xR [expr $xL + $dX]
      for { set I 0 } { $I < $ptANS(nRow) } { incr I } {
         set yT [expr $yTop - $I * ( $dY + $pGy) ]
         set yB [expr $yT- $dY]
	 if { ($I == 0) || ($J == $lC) } { 
	    set ptANS(pCor$I,$J) [list $xL $xR $yB $yT]
         }
         set WinInfo($pN,corFmt) 1
         RelWindow $pN A $xL $yB 0. $xR $yT 0. $ptANS(pMin) $ptANS(tMin) 0. \
                                               $ptANS(pMax) $ptANS(tMax) 0.
         if ![string match CARTESIAN $ptANS(tCoSyS)] {
            PLTinfoChg $pN ALL AXIS FORMAT MAP
         }
         DefinePlot $pN $pN 
	 incr pN
      }
   }

   PTlabSizes

   set ptANS(cByt) [expr $yB - 7 * $cSY] 
   set ptANS(cByb) [expr $yB - 9 * $cSY] 
   set ptANS(cBxl) $xLeft
   set ptANS(cBxr) [expr $xLeft + ($ptANS(nCol) - 1) * ($dX + $pGx) + $dX]

# MIGHT as well put up the main label now.  If this is a SINGLE plot set
#   then add in the energy step to the label

#  set MainL "$ptANS(0,P).$ptANS(0,M).$ptANS(0,E).$ptANS(0,I).$ptANS(0,V)"
#  set X  [expr ($xRight + $xLeft) / 2.0] 
#  set Y  [expr $yS - 1.5 * $cSY] 
#  if !$ptANS(PType) {
#     set Lab [format "  (%7.1f eV)" $ptANS(eV0)]
#     append MainL $Lab
#  }
#  TexT A $X $Y 0.0 center $MainL $GphInfo(bColor)

   update
}
