# THIS procedure resets the variable menu items.  With VPARAVPERP plots you
#    get all the energies between the minimum and maximum energy selected.

package provide ptPlots 1.0

proc PTplotIds { } {
   global ptANS eVC ExDa

# GET the center energy of all the energy steps being returned.  There is
#   one set per defined PLOT source. Also initialize the plot iD and 
#   used energy lists.

   set nPS [llength $ptANS(PSrc)]

   for { set I 0 } { $I < $nPS } { incr I } {
      set sN [lindex $ptANS(PSrc) $I]
      set ptANS($sN,pID)  ""
      set ptANS($sN,eVID) ""
      if ![info exist ptANS($sN,GoteVC)] { 
         set uA [lindex $ptANS($sN,aUnit) 0]
      
         set S [ReadUDF $ptANS($sN,KeY) 0 0 0 0 0 0]
         ConvertToUnits $ptANS($sN,KeY) 0 0 $uA eTmP
         set ptANS($sN,bT) [TUtimeFmt 0 $ExDa(0,BYR) $ExDa(0,BDY) \
	                                  $ExDa(0,BMSEC) $ExDa(0,BNSEC)]
					  
         set ptANS($sN,NSMP) $ExDa(0,NSMP)
         for { set J 0 } { $J < $ExDa(0,NSMP) } { incr J } {
            set eVC($sN,$J) $eTmP($J)
	 }
      }
   }

# INITIALIZE the energy steps to plot for this source and their energies
# THIS is done differently for VPVP plots.  If this is a VPVP plot then
#   take all the energies between the highest and lowest selected otherwise
#   take just the selected energies.

# NOT a VPVP plot

   if !$ptANS(VpVp) {
      for { set I 0 } { $I < $nPS } { incr I } {
         set sN [lindex $ptANS(PSrc) $I]
         for { set J 0 } { $J < $ptANS($sN,NSMP) } { incr J } {
            if $ptANS($sN,eS$J) { 
               lappend ptANS($sN,pID) $J 
               lappend ptANS($sN,eVID) $eVC($sN,$J) 
            }
         }
      }

#  Make sure all the sources have the same number of energy steps selected.

      set nEs [llength $ptANS([lindex $ptANS(PSrc) 0],pID)]
      for { set I 1 } { $I < $nPS } { incr I } {
         set sN [lindex $ptANS(PSrc) $I]
         set TmP [llength $ptANS($sN,pID)]
         if { $TmP != $nEs } {
            puts stderr "MISMATCHED NUMBER of ENERGY STEPS"
            exit
         }
      }

# NOW set the number of rows of PT plots in the figure.

      if { $nEs > 1 } {
         set ptANS(nRow) $nEs
         set ptANS(eRow) $nEs
      } else { 
         if { $nPS > 1 } {
            set ptANS(nRow) $nPS
            set ptANS(eRow) 1
         } else { set ptANS(eRow) 1 ; set ptANS(nRow) $ptANS(sRow) }
      }
   } else {

# WITH VPARAVPERP plots we need all the energy steps between the first and
#   the last selected. Plots are of velocity so save that

      for { set I 0 } { $I < $nPS } { incr I } {
         set sN [lindex $ptANS(PSrc) $I]

         set First -1
         for { set J 0 } { $J < $ptANS($sN,NSMP) } { incr J } {
            if $ptANS($sN,eS$J) { 
               if { $First < 0 } { set First $J }
	       set Last $J
            }
         }
         for { set J $First } { $J <= $Last } { incr J } {
            lappend ptANS($sN,pID) $J 
            lappend ptANS($sN,eVID) $eVC($sN,$J)
         }
         set nEs [llength $ptANS($sN,pID)]

# GET the smoothing factor.  Minimum allowable is 1

         if { $ptANS(Smooth) <= 0 } { set sM 1 } else { set sM $ptANS(Smooth) }

# Get the maximum grid value. 

         set e1 [lindex $ptANS($sN,eVID) 0]
         set e2 [lindex $ptANS($sN,eVID) end]
         if { $e2 < $e1 } { 
            set vMn [expr sqrt($e2 * $ptANS(toV))]
            set vMx [expr sqrt($e1 * $ptANS(toV))]
         } else {
            set vMx [expr sqrt($e2 * $ptANS(toV))]
            set vMn [expr sqrt($e1 * $ptANS(toV))]
         } 

         set nE [expr ($nEs - 1) * $sM + 1] 

	 set rV [PLTautoScale [expr -$vMx] $vMx 0 $ptANS(XTics)] 
	 set vMx [lindex $rV 1]
        
         set ptANS(vMaX) $vMx
         set ptANS(vMiN) $vMn

         set ptANS(pMin) [expr -$vMx]
         set ptANS(tMin) [expr -$vMx]
         set ptANS(pMax) $vMx
         set ptANS(tMax) $vMx

         set ptANS(eRow) 1 
         set ptANS(nRow) $ptANS(sRow)
      }
   }
}
