#  THIS procedure opens the data sources

package provide ptPlots 1.0

proc PTopenSrcs { } {
   global SInfo ptANS Pidf0 ExDa GSEtoSC

# THIS is the number of Sources's that need to be opened.

   if ![winfo exists .ptVAR] { PTguiVar 1 }
   set W .ptVAR.body.list
   set nS [$W index end]

# GET the time range.  Need at least Year/Day
                                                                                
   set bY  100;  set bD 1 ; set bH 0 ; set bM 0 ; set bS 0;
   set eY 9000;  set eD 1 ; set eH 0 ; set eM 0 ; set eS 0;
   if ![string match YEAR $ptANS(yRb)] { set bY $ptANS(yRb) } else { exit }
   if ![string match DAY  $ptANS(dYb)] { set bD $ptANS(dYb) } else { exit }
   if ![string match HR   $ptANS(hRb)] { set bH $ptANS(hRb) }
   if ![string match MIN  $ptANS(mNb)] { set bM $ptANS(mNb) }
   if ![string match SEC  $ptANS(sCb)] { set bS $ptANS(sCb) }
   if ![string match YEAR $ptANS(yRe)] { set eY $ptANS(yRe) } else { exit }
   if ![string match DAY  $ptANS(dYe)] { set eD $ptANS(dYe) } else { exit }
   if ![string match HR   $ptANS(hRe)] { set eH $ptANS(hRe) }
   if ![string match MIN  $ptANS(mNe)] { set eM $ptANS(mNe) }
   if ![string match SEC  $ptANS(sCe)] { set eS $ptANS(sCe) }

# ALL other sources use the same time range but the beginning time is
#   backed off 5 minutes to ensure that there is data there at the start
#   of the moments and the ending time is advanced by 5 minutes.

   set sY $bY ; set sD $bD ; set sH $bH ; set sM [expr $bM - 5] ; set sS $bS
   set fY $eY ; set fD $eD ; set fH $eH ; set fM [expr $eM + 5] ; set fS $eS

   if { $sM < 0 } {
      incr sM 60 ; incr sH -1
      if { $sH < 0 } { incr sH 24 ; incr sD -1 }
      if { $sD < 1 } {
         incr sY -1
         incr sD [TUyearLeap $sY]
      }
   }
   if { $fM > 59 } {
      incr fM -60 ; incr fH
      if { $fH > 23 } { incr fH -24 ; incr fD }
      set DiY [TUyearLeap $fY]
      if { $fD > $DiY } {
         incr fY
         incr fD -$DiY
      }
   }

# OPEN the sources -- remember to keep track of the location of the defined
#    PLOT sources.

   for { set S 0 } { $S < $nS } { incr S } {
      set sDef [$W get $S]
      scan $sDef "%d" sN

      if $ptANS(Stat$sN) { continue } else { set ptANS(Stat$sN) 1 }

      if [string match UDF $ptANS($sN,sBase)] {
         if [string match PLOT $ptANS($sN,sType)] {

# MAKE sure that we haven't already included this source in the source
#   list

	     if [info exists ptANS(PSrc)] {
	        if { [lsearch -exact $ptANS(PSrc) $sN] < 0 } {
	           lappend ptANS(PSrc) $sN
                }
	     } else { lappend ptANS(PSrc) $sN }

             PTopenUDF $sN $bY $bD $bH $bM $bS $eY $eD $eH $eM $eS 
         } else { 
             PTopenUDF $sN $sY $sD $sH $sM $sS $fY $fD $fH $fM $fS 
         }
      } else {
         PTopenCAA $sN $sY $sD $sH $sM $sS $fY $fD $fH $fM $fS 
      }
   }
}
