# THIS procedure puts up the plots
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTmkPlot { sN Row Col ImG Elev Phase } {
   global ptANS pgI cInputs GphInfo DevCt mfInfo

   upvar $ImG   V
   upvar $Elev  E
   upvar $Phase P

# PLOT position variables

   set pN [expr $Row + $ptANS(nRow) * $Col]

# This is the energy step we are plotting

   if { $ptANS(eRow) == 1 } {
      set eS [lindex $ptANS($sN,pID) 0]
   } else { set eS [lindex $ptANS($sN,pID) $Row] }

# Split out the data

   set ZMxMn [PTgetEv $sN $eS pgI V E P pGrid]

   if { [string length $ZMxMn] > 0 } {

# GET MAX/MIN values in plot 

      if $ptANS(AutoS) {
         if ![string match NONE $ptANS(iMin)] {
            set cInputs(pMIN) $ptANS(iMin)
	 } else { set cInputs(pMIN) [lindex $ZMxMn 0] }
         set cInputs(pMAX) [lindex $ZMxMn 1]
         if { $cInputs(pMIN) == $cInputs(pMAX) } {
            if { $cInputs(pMIN) == 0.0 } {
	       set cInputs(pMAX) 0.01  
	    } else { set cInputs(pMAX) [expr $cInputs(pMIN) * 1.01] }
         }
      } else {
         set cInputs(pMIN) $ptANS(iMin)
         set cInputs(pMAX) $ptANS(iMax)
      }

      PLTcolorMap $cInputs(pMIN) $cInputs(pMAX) $cInputs(pSCA) NO cI

      set pgI(PF) FLAT
#     set pgI(PF) ELEVATE
      TUgridInfo 30 pgI Xx
      TUgridInfo 31 pgI Yy

      SetCorSys $ptANS(tCoSyS) $ptANS(csInfo)

      set cS [string match SOLID $ptANS(cFmt)] 
      set cL [string match LINES $ptANS(cFmt)] 
      set cB [string match BOTH  $ptANS(cFmt)] 

#     if { $cS || $cB }  { Plot3D $pN Xb Yb Xx Yy pGrid MANUAL pgI cI }
      if { $cS || $cB }  { PLTflatPlot $pN Xb Yb Xx Yy pGrid MANUAL pgI cI }
      if { $cL || $cB }  { PTdrwContours $pN pGrid pgI } 

      PTcutPlot $sN $pN pGrid pgI $cInputs(pMIN) $cInputs(pMAX) $cInputs(pSCA)

      if { $mfInfo(0) > -1000 } {
         TUgridInfo 0 pgI rV $mfInfo(0) $mfInfo(1)
	 scan $DevCt([GetColor $pGrid($rV(0)) cI]) "#%02x%02x%02x" r g b
	 set R [expr $r ^ 255]
	 set G [expr $g ^ 255]
	 set B [expr $b ^ 255]
	 set mfInfo(colorA) [format "#%02x%02x%02x" $R $G $B]
	 TUgridInfo 0 pgI rV $mfInfo(2) $mfInfo(3)
	 scan $DevCt([GetColor $pGrid($rV(0)) cI]) "#%02x%02x%02x" r g b
         set R [expr $r ^ 255]
         set G [expr $g ^ 255]
         set B [expr $b ^ 255]
	 set mfInfo(colorB) [format "#%02x%02x%02x" $R $G $B]
      }
   } else {
      set cInputs(pMIN) ""
      set cInputs(pMAX) ""
      set mfInfo(colorA) $GphInfo(bColor)
      set mfInfo(colorB) $GphInfo(bColor)
   }
   PTplotEnd $sN $pN $Row $Col
   update
}
