# This procedure saves the Moments menu entries

package provide ptPlots 1.0
                                                                                
proc PTmenuSave { } {
   global env ptANS

   if [catch {open $ptANS(MenuSave) w} fd] {
      puts stderr "UNABLE TO OPEN SAVEFILE: $ptANS(MenuSave)"
      return
   }

# SAVE the time menu

   PTallInits TIME

   puts $fd "BEGIN TIME"
   set nV [PTvarList TIME vL]
   for { set I 0 } { $I < $nV } { incr I } {
      set vN [lindex [lindex $vL $I] 0]
      puts $fd "$vN|$ptANS($vN)"
   }
   puts $fd "END TIME"

# SAVE the variable definitions if there are any

   if ![winfo exists .ptVAR] { PTguiVar 1 }
   set W .ptVAR.body.list
   PTsetSBase

# THIS is the number of variable definitions

   set nS [$W index end]
   set PloT ""

   if { $nS > 0 } { 
      puts $fd "BEGIN VARIABLE"

      for { set I 0 } { $I < $nS } { incr I } {
         set vDef [$W get $I]
         scan $vDef "%d" sN
      
         puts $fd "BEGIN VSLOT $I"

         PTallInits VARIABLE $sN
         set nV [PTvarList VARIABLE vL]
         for { set J 0 } { $J < $nV } { incr J } {
            set vI [lindex $vL $J]
            set vN [lindex $vI 0]
            puts $fd "$I,$vN|$ptANS($sN,[lindex [lindex $vL $J] 0])"
         }

         if [string match UDF $ptANS($sN,sBase)] {
            puts $fd "BEGIN UDFSRC $I"
            set ptANS(UD$I,Title) "UDF DEFINITION $I"
	    GUsaveUDF $fd UD$sN ptANS UD$I
            puts $fd "END UDFSRC"

            if [string match PLOT $ptANS($sN,sType)] {
	       lappend PloT [list $I $sN]
            }
         }

         puts $fd "END VSLOT"
     }

      puts $fd "END VARIABLE"
   } 

# SAVE the selected energy steps

   puts $fd "BEGIN ESTEPS"
   set nSP [llength $PloT]
   for { set J 0 } { $J < $nSP } { incr J } {
      set New [lindex [lindex $PloT $J] 0]
      set Old [lindex [lindex $PloT $J] 1]

      if [info exists ptANS($Old,NSMP)] {
         puts $fd "$New,NSMP|$ptANS($Old,NSMP)"
         for { set I 0 } { $I < $ptANS($Old,NSMP) } { incr I } {
            puts $fd "$New,eS$I|$ptANS($Old,eS$I)"
         }
      }
   }
   puts $fd "END ESTEPS"

# SAVE the coordinate system information

   puts $fd "BEGIN COORDSYS"
   PTallInits COORD
   set nV [PTvarList COORD vL]
   for { set I 0 } { $I < $nV } { incr I } {
      set vN [lindex [lindex $vL $I] 0]
      puts $fd "$vN|$ptANS($vN)"
   }

   puts $fd "END COORDSYS"

# SAVE the plot definition information

   puts $fd "BEGIN PSET"
   PTallInits PSET
   set nV [PTvarList PSET vL]
   for { set I 0 } { $I < $nV } { incr I } {
      set vN [lindex [lindex $vL $I] 0]
      puts $fd "$vN|$ptANS($vN)"
   }

   puts $fd "END PSET"

# SAVE the fit information

   puts $fd "BEGIN FIT"
   PTallInits FIT
   set nV [PTvarList FIT vL]
   for { set I 0 } { $I < $nV } { incr I } {
      set vN [lindex [lindex $vL $I] 0]
      puts $fd "$vN|$ptANS($vN)"
   }

   puts $fd "END FIT"

# SAVE the correction information

   puts $fd "BEGIN COR"
   PTallInits COR
   set nV [PTvarList COR vL]
   for { set I 0 } { $I < $nV } { incr I } {
      set vN [lindex [lindex $vL $I] 0]
      puts $fd "$vN|$ptANS($vN)"
   }

   puts $fd "END COR"

# SAVE the masks menu

   if ![winfo exists .ptMask] { PTguiMasks 1 }
   set W .ptMask.body.list

# THIS is the number of mask definitions

   set nS [$W index end]

   if { $nS > 0 } { 
      puts $fd "BEGIN MASKS"

      set nV [PTvarList MASKS vL]
      set FmT "%s"
      set VaR "A(0)"
      for { set I 1 } { $I < $nV } { incr I } {
          append FmT " %s"
          append VaR " A($I)"
      }
      for { set I 0 } { $I < $nV } { incr I } { set B($I) "" }

      for { set I 0 } { $I < $nS } { incr I } {
         set LiNe [$W get $I]
	 set LiNe [string trim $LiNe]
	 set rCmd { scan "$LiNe" "$FmT" }
	 append rCmd $VaR
	 eval $rCmd
         for { set J 0 } { $J < $nV } { incr J } {
	    if [string match $ptANS(EmptyVar) $A($J)] {
	       lappend B($J) ""
	    } else { lappend B($J) $A($J) }
         }
      }

      for { set I 0 } { $I < $nV } { incr I } {
	  puts $fd "[lindex [lindex $vL $I] 0]|$B($I)"
      }

      puts $fd "END MASKS"
   }

   if ![winfo exists .ptCuts] { PTguiCuts 1 }
   set W .ptCuts.body.list

# THIS is the number of mask definitions

   set nS [$W index end]

   if { $nS > 0 } { 
      puts $fd "BEGIN CUTS"

      set nV [PTvarList CUTS vL]
      set FmT "%s"
      set VaR "A(0)"
      for { set I 1 } { $I < $nV } { incr I } {
          append FmT " %s"
          append VaR " A($I)"
      }
      for { set I 0 } { $I < $nV } { incr I } { set B($I) "" }

      for { set I 0 } { $I < $nS } { incr I } {
         set LiNe [$W get $I]
	 set LiNe [string trim $LiNe]
	 set rCmd { scan "$LiNe" "$FmT" }
	 append rCmd $VaR
	 eval $rCmd
         for { set J 0 } { $J < $nV } { incr J } {
	    if [string match $ptANS(EmptyVar) $A($J)] {
	       lappend B($J) ""
	    } else { lappend B($J) $A($J) }
         }
      }

      for { set I 0 } { $I < $nV } { incr I } {
	  puts $fd "[lindex [lindex $vL $I] 0]|$B($I)"
      }

      puts $fd "END CUTS"
   }

# SAVE the label mod menu

   PTallInits LABELS

   puts $fd "BEGIN LABELS"
   set nV [PTvarList LABELS vL]
   for { set I 0 } { $I < $nV } { incr I } {
      set vN [lindex [lindex $vL $I] 0]
      puts $fd "$vN|$ptANS($vN)"
   }
   puts $fd "END LABELS"


# SAVE the postscript menu

   PTallInits PSCRIPT

   puts $fd "BEGIN PSCRIPT"
   set nV [PTvarList PSCRIPT vL]
   for { set I 0 } { $I < $nV } { incr I } {
      set vN [lindex [lindex $vL $I] 0]
      puts $fd "$vN|$ptANS($vN)"
   }
   puts $fd "END PSCRIPT"

   close $fd
}
