# THIS procedure reads a menu file to get all of the user set options

package provide ptPlots 1.0

proc PTmenuRead { } {
   global ptANS GUIoptPri GUIoptAlts

   if [catch {open $ptANS(MenuRead) r} fd] {
      puts stderr "UNABLE TO OPEN MENUFILE: $ptANS(MenuRead)"
      return
   }

#  READ in the saved values.  Blocks or saved replies in the menu are
#     separated by BEGIN and END.  These can be ignored.

   while { [gets $fd line] > 0 } {
      set nW [lindex $line 0] 
      if [string match END $nW]   { continue }
      if [string match BEGIN $nW] { 
         set fN [lindex $line 1]
	 if { [lsearch $ptANS(fItems) $fN] >= 0 } {
             set pI ${fN},rd 
	     set ptANS($pI) 1
         }
         continue 
      }

      set Fields [split $line '|']
      set I [lindex $Fields 0]

# CHECK for old PV0 ID and change it to PV

      if [string match PV0 $I] { set I PV }

      set tV [lindex [split $I ","] 1]  
      if [string match sType $tV] {
         if [string match MAGFIELD [lindex $Fields 1]] {
            set ptANS($I) MF-UDF
         } elseif [string match POTENTIAL [lindex $Fields 1]] {
            set ptANS($I) POT-UDF
         } else { set ptANS($I) [lindex $Fields 1] }
      } else { set ptANS($I) [lindex $Fields 1] }
   }

   close $fd
}
