# THIS procedure puts the main top level labels.  What goes up there depends
#   on what's being output
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTmainLabs { } {
   global env ptANS GphInfo GSEtoSC

   set nPS [llength $ptANS(PSrc)]
   set tF  [string match HOR $ptANS(tDir)]

# THIS is the character XY sizes

   set cW $GphInfo(curWin)
   set GphInfo(curWin) A
   TextProp $ptANS(mLSize)
   set chL [GPHtextLen A XY]
   set cSX [lindex $chL 0]
   set cSY [lindex $chL 1]
      
# THIS is the left and right edge of the plots in X

   set xLeft  [expr 6 * $cSX]
   set xRight [expr ($GphInfo(xScrL) - 1) - 8 * $cSX]

# PUT up a source label centered on the plots.  This label is always
#   present and is the main top label.

   set sN [lindex $ptANS(PLOT) 0]
   set S UD$sN
   
# IF only one source then we can put up the full UDF hierarchy.  IF not then
#    just put up the PROJECT and EXPERIMENT.

   set LaB ""
   if { [string length $ptANS(mLab)] == 0 } { 
      set LaB ""
   } else {
      set tStr $ptANS(mLab)
      set P [string first "_" $tStr]
      while { $P >= 0 } {
         set BeG [expr $P + 1]
         if { $P > 0 } { 
            set EnD [expr $P - 1]
	    append LaB [string range $tStr 0 $EnD] 
	 }
	 set cH [string index $tStr $BeG]
         append LaB "$ptANS($S,$cH)"
	 incr BeG
	 set tStr [string range $tStr $BeG end]
         set P [string first "_" $tStr]
      }
      append LaB "$tStr"
   }

#  set X  [expr ($xRight + $xLeft) / 2.0]
   set X  [expr ($ptANS(cBxl) + $ptANS(cBxr)) / 2.0]
   set Y  [expr ($GphInfo(yScrL) - 1) - 1.5 * $cSY]
   TexT A $X $Y 0.0 center $LaB $ptANS(mLColor)

# Drop Y to location of next Label in case there is a second

   set Y [expr $Y - 2.0 * $cSY]

# SET top label size

   TextProp $ptANS(tLSize)

# IF this is a VPARA-VPERP plot then we need add the year and day and 
#   the energy range.

   if $ptANS(VpVp) {
      set LaB  "[lindex $ptANS($sN,bT) 0] [lindex $ptANS($sN,bT) 1]"
      set E1 [lindex $ptANS($sN,eVID) 0] 
      set E2 [lindex $ptANS($sN,eVID) end] 
      if { $E1 > $E2 } {
         append LaB [format "  (%.1f - %.1f eV)" $E2 $E1] 
      } else { append LaB [format "  (%.1f - %.1f eV)" $E1 $E2] } 
      TexT A $X $Y 0.0 center $LaB $ptANS(tLColor)
   } 

# IF this is a set of monoenergetic plots from a singe source then add the
#    year/day and energy

   if { ($nPS == 1) && ($ptANS(eRow) == 1) && !$ptANS(VpVp)} {
      set LaB  "[lindex $ptANS($sN,bT) 0] [lindex $ptANS($sN,bT) 1]"
      append LaB [format "  (%.1f eV)" [lindex $ptANS($sN,eVID) 0]] 
      TexT A $X $Y 0.0 center $LaB $ptANS(tLColor)
   }

# IF this is a set of monoenergetic plots from multiple sources and its
#   being plotted horizontally then add the year/day 

   if { ($nPS > 1) && ($ptANS(eRow) == 1) && !$ptANS(VpVp)} {
      set LaB  "[lindex $ptANS($sN,bT) 0] [lindex $ptANS($sN,bT) 1]"
      TexT A $X $Y 0.0 center $LaB $ptANS(tLColor)
   }

   TextProp 12
   set GphInfo(curWin) $cW
}
