# THIS procedure contains plot setup information
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTguiPSet { } {
   global env ptANS Prefs

   set W .ptPset

    set bSize [expr $Prefs(FontSize) + 2]
    set LFonT [list "" "" bold]
    set BFonT [list "" $bSize bold]

   set LaB "PLOT SETUP"
   if [GUIWindow $W $LaB] {

      PTallInits PSET

      set Wa $W.cmd
      set Wb $W.body

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb -1 grid|1|0|news
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"

      set OpA [list LOG LINEAR]
      set OpB [list SOLID LINES BOTH]
      set OpC [list FLOW INST]
      set OpD [list YES NO]
      set OpE [list HOR VER]
      set OpF [list "NEAREST SPIN" "NEAREST SWEEP"]

      set R 0
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Color Table" w grid|$R|0|w||3 \
	                  0 -1 #0000FF $BFonT

      set Ops [GUctblOpts]

# IF there is a defined ctbl then get its label

      set nO [llength $Ops]
      set Empty 1
      for { set I 0 } { $I < $nO } { incr I } {
         set cBe [split [lindex $Ops $I] '|']
         if [string match [lindex $cBe 1] $ptANS(ctbl)] {
            set Lab [lindex $cBe 0]
            set Empty 0
            break
         }
      }

      if $Empty {
         set Lab [lindex [split [lindex $Ops 0] '|'] 0]
	 set ptANS(ctbl) [lindex [split [lindex $Ops 0] '|'] 1]
      }

      GUIbuttonMenu $Wb.ctbl $Lab grid|$R|1|ew||2 $Ops  \
                          "GUIoptsProcess $Wb.ctbl ptANS(ctbl) ALT "


      incr R
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Window Size" w grid|$R|0|w||3 \
	                  0 -1 #0000FF $BFonT

      incr R
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.t$R "Width" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.xpx grid|$R|1| 8 ptANS(xPix)
      GUILabel $Wb.et$R pixels w grid|$R|2

      incr R 
      GUILabel $Wb.t$R "Heigth" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.ypx grid|$R|1| 8 ptANS(yPix)
      GUILabel $Wb.et$R pixels w grid|$R|2

      incr R
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Scaling Information" w grid|$R|0|w||3 \
	                  0 -1 #0000FF $BFonT

      incr R
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.t$R "Minimum Intenity" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.imn grid|$R|1| 8 ptANS(iMin)

      incr R 
      GUILabel $Wb.t$R "Maximum Intensity" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.imx grid|$R|1| 8 ptANS(iMax)

      incr R 
      GUILabel $Wb.t$R "Scale" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonToggle $Wb.isc $ptANS(iSca) grid|$R|1 $OpA \
              "GUIoptsToggle $Wb.isc ptANS(iSca) PRI" 0

      incr R
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Contouring Information" w grid|$R|0|w||3 \
	                  0 -1 #0000FF $BFonT

      incr R
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Format System" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonMenu $Wb.cfmt $ptANS(cFmt) grid|$R|1| $OpB \
		     "GUIoptsProcess $Wb.cfmt ptANS(cFmt) PRI " 0

      incr R 
      GUILabel $Wb.t$R "SMoothing Factor" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.sm grid|$R|1| 8 ptANS(Smooth)

      incr R 
      GUILabel $Wb.t$R "Contour Levels" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.cLev grid|$R|1| 8 ptANS(cLev)

      incr R
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Vparp/Vperp Information" w grid|$R|0|w||3 \
	                  0 -1 #0000FF $BFonT

      incr R
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.t$R "X Grid Cells" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.xgs grid|$R|1| 8 ptANS(xGs)

      incr R 
      GUILabel $Wb.t$R "Y Grid Cells" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.ygs grid|$R|1| 8 ptANS(yGs)

      incr R
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Output Information" w grid|$R|0|w||3 \
	                  0 -1 #0000FF $BFonT

      incr R
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.t$R "Skip Spins" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.skp grid|$R|1| 8 ptANS(SpinSkip)

      incr R 
      GUILabel $Wb.t$R "Frame of Reference" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonToggle $Wb.rf $ptANS(LookDir) grid|$R|1 $OpC \
              "GUIoptsToggle $Wb.rf ptANS(LookDir) PRI" 0

      incr R 
      GUILabel $Wb.t$R "Show MagField" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonToggle $Wb.pmf $ptANS(pMF) grid|$R|1 $OpD \
              "GUIoptsToggle $Wb.pmf ptANS(pMF) PRI" 0

      incr R 
      GUILabel $Wb.t$R "HiRes MagField" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonToggle $Wb.hrmf $ptANS(hrMF) grid|$R|1 $OpD \
              "GUIoptsToggle $Wb.hrmf ptANS(hrMF) PRI" 0

      incr R 
      GUILabel $Wb.t$R "Min Rows/Col" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.mrw grid|$R|1| 8 ptANS(sRow)

      incr R 
      GUILabel $Wb.t$R "Time Flow" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonToggle $Wb.tfl $ptANS(tDir) grid|$R|1 $OpE \
              "GUIoptsToggle $Wb.tfl ptANS(tDir) PRI" 0

      incr R 
      GUILabel $Wb.t$R "Start" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonToggle $Wb.spos $ptANS(sPos) grid|$R|1 $OpF \
              "GUIoptsToggle $Wb.spos ptANS(sPos) PRI" -1

   } else { GUIwindowCtrl $W }
}
