# THIS procedure puts up a clip definition gui
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTguiMasks { { ImC 0 } } {
   global env ptANS Prefs


   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set W .ptMask
   set LaB "MASKS AND CLIPS"

   PTallInits MASKS
   if [GUIWindow $W $LaB] {

      if $ImC { GUIwindowCtrl $W }

      set Wa $W.top
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wc -1 grid|1|0|news
      GUIFrame $Wd -1 grid|2|0|news
      GUIFrame $We -1 grid|3|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      set R 0

      set LaBa [format $ptANS(MaskslfA) Energy Phi Theta]
      set LaBb [format $ptANS(MASKS,lf) Type Min Max Min Max Min Max %Max Inv]

      incr R 
      GUILabel $Wc.t$R $LaBa  w grid|$R|0|w 0 0 "" $CFonT
      incr R 
      GUILabel $Wc.t$R $LaBb  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 55 7  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "PTaddItem MASKS F" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "PTeditItem MASKS F" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "PTaddItem MASKS F REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "PTtwinCmd $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "PTvarReset MASKS" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "PTtwinCmd $W DELETE" 6

      set R 0
      GUIblankRow $We $R 2.5

      set OpsA [list CLIP_A CLIP_R MASK_A MASK_RT MASK_RH]

      incr R 
      GUIblankCol $We 0 1
      GUILabel $We.t$R  "Type" w grid|$R|0|w -1 0 "" $LFonT
      GUIbuttonMenu $We.mt $ptANS(mFmT) grid|$R|1|w $OpsA  \
                         "GUIoptsProcess $We.mt ptANS(mFmT) PRI " 6

      incr R 
      GUIblankRow $We $R 1.0

      incr R 
      GUILabel $We.l1 Start c grid|$R|1 0 -1 "" $LFonT
      GUILabel $We.l2 Stop  c grid|$R|2 0 -1 "" $LFonT

      incr R 
      GUILabel $We.t$R "Energy" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $We.minE grid|$R|1| 8 ptANS(mbEv)
      GUIboxEntry $We.maxE grid|$R|2| 8 ptANS(meEv)
      GUILabel $We.et$R eV w grid|$R|3

      incr R 
      GUILabel $We.t$R "Phi" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $We.minP grid|$R|1| 8 ptANS(mbPh)
      GUIboxEntry $We.maxP grid|$R|2| 8 ptANS(mePh)
      GUILabel $We.et$R deg w grid|$R|3

      incr R 
      GUILabel $We.t$R "Theta" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $We.minT grid|$R|1| 8 ptANS(mbTh)
      GUIboxEntry $We.maxT grid|$R|2| 8 ptANS(meTh)
      GUILabel $We.et$R deg w grid|$R|3

      incr R 
      GUILabel $We.t$R "% Max" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $We.pc grid|$R|1| 8 ptANS(pcClip)

      incr R 
      set oP [list NO YES]
      GUILabel $We.t$R "Inverse" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonToggle $We.inv $ptANS(mInv) grid|$R|1 $oP \
                     "GUIoptsToggle $We.inv ptANS(mInv) PRI" 0,0.5

      bind $W <Down> { PTtwinCmd %W MOVE DOWN }
      bind $W <Up> { PTtwinCmd %W MOVE UP }

      PTallInits  MASKS
      if [info exists ptANS(MASKS,rd)] { PTfillFLBox MASKS }
      PTfillGUI MASKS 

   } else { GUIwindowCtrl $W }
}
