
# THIS procedure contains plot setup information
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTguiLabs { } {
   global env ptANS Prefs

   set W .ptLabs

    set bSize [expr $Prefs(FontSize) + 2]
    set LFonT [list "" "" bold]
    set BFonT [list "" $bSize bold]

   set LaB "LABEL SETUP"
   if [GUIWindow $W $LaB] {

      PTallInits LABELS

      set Wa $W.cmd
      set Wb $W.body

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb -1 grid|1|0|news
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"

      set R 0
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Main Label" w grid|$R|0|w||5 0 -1 #0000FF $BFonT

      incr R
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.t$R "Label" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.mL grid|$R|1|w||4 40 ptANS(mLab)
      incr R 
      GUILabel $Wb.t$R "Size" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.mS grid|$R|1|w 8 ptANS(mLSize)
      incr R 
      GUILabel $Wb.t$R "Color" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonPush $Wb.mlc "" grid|$R|1|w \
                          "GUIcolorPick $Wb.mlc ptANS(mLColor)" 0 8

      incr R
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Axis and Labels" w grid|$R|0|w||5 0 \
                                              -1 #0000FF $BFonT

      incr R
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.ta$R "Size" w grid|$R|1|ew 0  -1 "" $LFonT
      GUILabel $Wb.tb$R "Color" w grid|$R|2|ew 0 -1 "" $LFonT

      incr R
      GUIblankRow $Wb $R 0.5

      incr R 
      GUILabel $Wb.t$R "Top Label" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.tS grid|$R|1|w 8 ptANS(tLSize)
      GUIbuttonPush $Wb.tlc "" grid|$R|2|w \
                          "GUIcolorPick $Wb.tlc ptANS(tLColor)" 0 8

      incr R 
      GUILabel $Wb.t$R "Axis Labels" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.ax grid|$R|1|w 8 ptANS(PaxSO)
      GUIbuttonPush $Wb.axc "" grid|$R|2|w \
                          "GUIcolorPick $Wb.axc ptANS(PaxCO)" 0 8

      incr R 
      GUILabel $Wb.t$R "Axes" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonPush $Wb.axisc "" grid|$R|2|w \
                          "GUIcolorPick $Wb.axisc ptANS(AxCO)" 0 8

      incr R
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Plot Label Size Offsets and Colors" w grid|$R|0|w||5 \
	                  0 -1 #0000FF $BFonT

      incr R
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.ta$R "Size Offset" w grid|$R|1|ew 0 -1 "" $LFonT
      GUILabel $Wb.tb$R "Color" w grid|$R|2|ew 0 -1 "" $LFonT
      GUILabel $Wb.tc$R "Format" w grid|$R|3|ew 0 -1 "" $LFonT
      GUILabel $Wb.td$R "Bold" w grid|$R|4|ew 0 -1 "" $LFonT

      incr R
      GUIblankRow $Wb $R 0.5

      incr R 
      GUILabel $Wb.t$R "Time" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.tm grid|$R|1|w 8 ptANS(PtmSO)
      GUIbuttonPush $Wb.tmc "" grid|$R|2|w \
                          "GUIcolorPick $Wb.tmc ptANS(PtmCO)" 0 8
      GUIbuttonCheck $Wb.tmb "" grid|$R|4|w ptANS(PtmBld) ""

      incr R 
      GUILabel $Wb.t$R "Scaling" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.sca grid|$R|1|w 8 ptANS(PscaSO)
      GUIbuttonPush $Wb.scc "" grid|$R|2|w \
                          "GUIcolorPick $Wb.scc ptANS(PscaCO)" 0 8
      GUIboxEntry $Wb.scf grid|$R|3|w 8 ptANS(PscaFmt)
      GUIbuttonCheck $Wb.scb "" grid|$R|4|w ptANS(PscaBld) ""

      incr R 
      GUILabel $Wb.t$R "Mea. Energy" w grid|$R|0|w 0 12 "" $LFonT
      GUIboxEntry $Wb.mev grid|$R|1|w 8 ptANS(PmevSO)
      GUIbuttonPush $Wb.mevc "" grid|$R|2|w \
                          "GUIcolorPick $Wb.mevc ptANS(PmevCO)" 0 8
      GUIboxEntry $Wb.mef grid|$R|3|w 8 ptANS(PmevFmt)
      GUIbuttonCheck $Wb.meb "" grid|$R|4|w ptANS(PmevBld) ""

      incr R 
      GUILabel $Wb.t$R "Cor. Energy" w grid|$R|0|w 0 12 "" $LFonT
      GUIboxEntry $Wb.cev grid|$R|1|w 8 ptANS(PcevSO)
      GUIbuttonPush $Wb.cevc "" grid|$R|2|w \
                          "GUIcolorPick $Wb.cevc ptANS(PcevCO)" 0 8
      GUIboxEntry $Wb.cef grid|$R|3|w 8 ptANS(PcevFmt)
      GUIbuttonCheck $Wb.ceb "" grid|$R|4|w ptANS(PcevBld) ""

      incr R
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Magnetic Field Projections" w grid|$R|0|w||5 \
	                  0 -1 #0000FF $BFonT

      incr R
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.ta$R "Symbol" w grid|$R|1|ew 0 -1 "" $LFonT
      GUILabel $Wb.tb$R "Size" w grid|$R|2|news 0 -1 "" $LFonT
      GUILabel $Wb.tc$R "Color" w grid|$R|3|ew 0 -1 "" $LFonT
      GUILabel $Wb.td$R "AutoCol" w grid|$R|4|ew 0 -1 "" $LFonT

      incr R
      GUIblankRow $Wb $R 0.5

      incr R
      GUILabel $Wb.t$R "Head" w grid|$R|0|w 0 10 "" $LFonT
      GUIboxEntry $Wb.mfh grid|$R|1|w 8 ptANS(MfHSym)
      GUIboxEntry $Wb.mfhs grid|$R|2|w 8 ptANS(MfHS)
      GUIbuttonPush $Wb.mfhc "" grid|$R|3|w \
                          "GUIcolorPick $Wb.mfhc ptANS(MfHC)" 0 8
      GUIbuttonCheck $Wb.hac "" grid|$R|4|w ptANS(MfHac) ""

      incr R
      GUILabel $Wb.t$R "Tail" w grid|$R|0|w 0 10 "" $LFonT
      GUIboxEntry $Wb.mft grid|$R|1|w 8 ptANS(MfTSym)
      GUIboxEntry $Wb.mfts grid|$R|2|w 8 ptANS(MfTS)
      GUIbuttonPush $Wb.mftc "" grid|$R|3|w \
                          "GUIcolorPick $Wb.mftc ptANS(MfTC)" 0 8
      GUIbuttonCheck $Wb.tac "" grid|$R|4|w ptANS(MfTac) ""

      bind $Wb.mfh <Button-3> { GUIsymPick .ptLabs.body.mfh ptANS(MfHSym) }
      bind $Wb.mft <Button-3> { GUIsymPick .ptLabs.body.mft ptANS(MfTSym) }

      PTfillGUI LABELS

   } else { GUIwindowCtrl $W }
}
