# THIS procedure puts up a clip definition gui
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTguiCuts { { ImC 0 } } {
   global env ptANS Prefs


   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set W .ptCuts
   set LaB "CUTS"

   set shOps [list SHOW OMIT]
   set axOps [list X Y]

   PTallInits CUTS
   if [GUIWindow $W $LaB] {

      if $ImC { GUIwindowCtrl $W }

      set Wa $W.top
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wc -1 grid|1|0|news
      GUIFrame $Wd -1 grid|2|0|news
      GUIFrame $We -1 grid|3|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      set R 0

      set LaBa [format $ptANS(CUTS,lf) X1 Y2 X2 Y2 Color lW Cut Axis]

      incr R 
      GUILabel $Wc.t$R $LaBa  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 55 7  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "PTaddItem CUTS F" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "PTeditItem CUTS F" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "PTaddItem CUTS F REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "PTtwinCmd $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "PTvarReset CUTS" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "PTtwinCmd $W DELETE" 6

      set R 0
      GUIblankRow $We $R 2.5

      incr R 
      GUIblankRow $We $R 1.0

      incr R 
      GUILabel $We.l1 X1 c grid|$R|1 0 -1 "" $LFonT
      GUILabel $We.l2 Y1 c grid|$R|2 0 -1 "" $LFonT
      GUILabel $We.l3 X2 c grid|$R|3 0 -1 "" $LFonT
      GUILabel $We.l4 Y2 c grid|$R|4 0 -1 "" $LFonT
      GUILabel $We.l5 Color c grid|$R|5 0 -1 "" $LFonT
      GUILabel $We.l6 Width c grid|$R|6 0 -1 "" $LFonT
      GUILabel $We.l7 Cut c grid|$R|7 0 -1 "" $LFonT
      GUILabel $We.l8 Axis c grid|$R|8 0 -1 "" $LFonT

      incr R 
      GUILabel $We.t$R "Range" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $We.minX grid|$R|1| 10 ptANS(xMn)
      GUIboxEntry $We.maxX grid|$R|2| 10 ptANS(yMn)
      GUIboxEntry $We.minY grid|$R|3| 10 ptANS(xMx)
      GUIboxEntry $We.maxY grid|$R|4| 10 ptANS(yMx)
      GUIbuttonPush $We.gc "" grid|$R|5|ew \
                    "GUIcolorPick $We.gc ptANS(cColor)" 0 8
      GUIboxEntry $We.lw grid|$R|6 8 ptANS(cWidth)
      GUIbuttonToggle $We.sl $ptANS(sLine) grid|$R|7 $shOps \
                     "GUIoptsToggle $We.sl ptANS(sLine) PRI" 0
      GUIbuttonToggle $We.pa $ptANS(pAxis) grid|$R|8 $axOps \
                     "GUIoptsToggle $We.pa ptANS(pAxis) PRI" 0

      bind $W <Down> { PTtwinCmd %W MOVE DOWN }
      bind $W <Up> { PTtwinCmd %W MOVE UP }

      PTallInits  CUTS
      if [info exists ptANS(CUTS,rd)] { PTfillFLBox CUTS }
      PTfillGUI CUTS 

   } else { GUIwindowCtrl $W }
}
