# THIS procedure contains coordinate system definition as well as 
#   some of the output options which pertain to them
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTguiCoor { } {
   global env ptANS Prefs

   set W .ptCoor

    set bSize [expr $Prefs(FontSize) + 2]
    set LFonT [list "" "" bold]
    set BFonT [list "" $bSize bold]

   set LaB "COORDINATE SYSTEM"
   if [GUIWindow $W $LaB] {

      PTallInits COORD

      set Wa $W.cmd
      set Wb $W.body

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb -1 grid|1|0|news
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"

      set R 0
      GUILabel $Wb.t$R "Integration Limits" w grid|$R|0|w||3 \
           0 -1 #0000FF $BFonT

      incr R 
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.t$R "Coordinate System" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonMenu $Wb.cosys $ptANS(CoSyS) grid|$R|1|||3 $ptANS(COSYS) \
                        "GUIoptsProcess $Wb.cosys ptANS(CoSyS) PRI " 6

      incr R
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Positioning" w grid|$R|0|w||3 \
	                  0 -1 #0000FF $BFonT
      incr R
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.t$R "Center Phi" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.cPhi grid|$R|1| 8 ptANS(cPhi)
      GUILabel $Wb.et$R deg w grid|$R|2

      incr R 
      GUILabel $Wb.t$R "Center Elevation" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.cElev grid|$R|1| 8 ptANS(cElev)
      GUILabel $Wb.et$R deg w grid|$R|2

      incr R
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.t$R "Radius" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.pRad grid|$R|1| 8 ptANS(pRad)
      GUILabel $Wb.et$R deg w grid|$R|2

      incr R
      GUIblankRow $Wb $R 1.0

      incr R
      GUILabel $Wb.t$R "Tick Mark Intervals" w grid|$R|0|w||3 \
	                  0 -1 #0000FF $BFonT

      incr R
      GUIblankRow $Wb $R 1.0

      incr R 
      GUILabel $Wb.t$R "Phi" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.dPhi grid|$R|1| 8 ptANS(dPhi)
      GUILabel $Wb.et$R deg w grid|$R|2

      incr R 
      GUILabel $Wb.t$R "Elevation" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.dElev grid|$R|1| 8 ptANS(dElev)
      GUILabel $Wb.et$R deg w grid|$R|2

      incr R 
      GUILabel $Wb.t$R "NS Edge" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $Wb.nse grid|$R|1| 8 ptANS(ElevEnd)
      GUILabel $Wb.et$R deg w grid|$R|2

   } else { GUIwindowCtrl $W }
}
