# THIS procedure puts up a clip definition gui
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTguiClip { { N -1 } } {
   global env ptANS Prefs

   if { $N == -1 } {
      set nF [llength $ptANS(cDef)]
      for { set J 0 } { $J < $nF } { incr J } {
         if ![lindex $ptANS(cDef) $J] { set N $J ; break }
      }
   } 

   if { $N == -1 } { return }

   set W .cDef$N
   set ptANS(cDef) [lreplace $ptANS(cDef) $N $N 1] 

   set ptANS($N,scr) 2

   if ![winfo exists $W] {
      toplevel $W
      wm title $W "CLIP DEFINITION $N"

      set Wa $W.mTOP
      set Wb $W.mOPT

      GUIFrame $Wa -1 pack|top||both|true
      GUIFrame $Wb -1 pack|top||both|true
      
      GUIbuttonPush $Wa.del DELETE pack|left "PTdelDef $W $N 1"  6
      GUILabel $Wa.lab "CLIP DEFINITION" c pack|left|center|x|true \
              6 20 "" [list times 16 bold]

      GUILabel $Wb.rlab "RANGE DEFINITIONS" c grid|0|0|ew||3 \
              6 20 "" [list times 12 bold]
      GUIblankRow $Wb 1 1.0

      set oP [list RELATIVE ABSOLUTE]

      GUILabel $Wb.t1 "ENERGY RANGE" w grid|2|0|w

      GUIbuttonToggle $Wb.ra $ptANS(RelAbs$N) grid|2|3 $oP \
              "GUIoptsToggle $Wb.ra ptANS(RelAbs$N) PRI" 0

      GUIboxEntry $Wb.minE grid|2|1| 8 ptANS(eBClip$N)
      GUIboxEntry $Wb.maxE grid|2|2| 8 ptANS(eEClip$N)

      GUILabel $Wb.t2 "AZIMUTH RANGE" w grid|3|0|w
      GUIboxEntry $Wb.minP grid|3|1| 8 ptANS(pBClip$N)
      GUIboxEntry $Wb.maxP grid|3|2| 8 ptANS(pEClip$N)

      GUILabel $Wb.t3 "ELEVATION RANGE" w grid|4|0|w
      GUIboxEntry $Wb.minT grid|4|1| 8 ptANS(tBClip$N)
      GUIboxEntry $Wb.maxT grid|4|2| 8 ptANS(tEClip$N)

      GUILabel $Wb.t4 "% MAX" w grid|5|0|w
      GUIboxEntry $Wb.pc grid|5|1| 8 ptANS(pcClip$N)
   }
}
