# THIS procedure determines the UDF sources.  These are either UDF based
#   sources or CAA pases sources

package provide ptPlots 1.0

proc PTgetSrcs { } {
   global ptANS 

# THIS is the number of UDF's that need to be opened.

   if ![winfo exists .ptVAR] { PTguiVar 1 }
   set W .ptVAR.body.list
   set nS [$W index end]

# SEPARATE the sources.  There are sources which belong to the PLOT.
#   MAGNETIC FIELD, and POTENTIAL.  While there may (someday) be
#   a need for multiple PLOT sources there is only 1 MF and POT source
#   allowed.

   set ptANS(PLOT) ""
   set ptANS(MAGFIELD)  ""
   set ptANS(POTENTIAL) ""
   set ptANS(VELOCITY)  ""

   set PV [list P M E I V]
   for { set S 0 } { $S < $nS } { incr S } {
      set sDef [$W get $S]
      scan $sDef "%d %s %s" sN TmP dSrc

      set ptANS(Stat$sN) 0

      set ptANS($sN,FmT) $dSrc 
      switch -exact -- $dSrc {
         PLOT { lappend ptANS(PLOT) $sN }

         MF-UDF -
         MF-CAA { lappend ptANS(MAGFIELD) $sN }

         POT-UDF -
         POT-CAA { lappend ptANS(POTENTIAL) $sN }

         VEL-UDF { lappend ptANS(VELOCITY) $sN }
      }

# LOOK for CAA data sources.  We only process UDF ones here.

      if ![info exists ptANS(Stat$sN)] { set ptANS(Stat$sN) 0 }

      if [string match UDF $ptANS($sN,sBase)] { 
         set iD UD$sN
         for { set I 0 } { $I < 5 } { incr I } {
	    set ChK [string trim $ptANS($iD,[lindex $PV $I])]
	    if { [string length $ChK] == 0 } { 
	       puts stderr "INCOMPLETE PMEIV definition for SOURCE $sN"
	       exit 
	    }
         }
      }
   }
}
