# THIS pulls out an energy slice from the data.
#
# eS is the energy step.
# eGrid is the grid of data
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTgetEv { sN eS pgInfo ImG Elev Phase eGrid } {
   global ptANS GphInfo RtoD

   upvar $ImG    V
   upvar $Elev   E
   upvar $Phase  P
   upvar $eGrid  eG
   upvar $pgInfo pI

   if { $ptANS(Smooth) <= 0 } { set sM 1 } else { set sM $ptANS(Smooth) }
   set sID $ptANS($sN,sID)

# DATA is stored as full sweeps, elevation by elevation and sector by 
#   sector.  PHASE is stored as full sweeps, sector by sector.

   set tE 0
   set pP $eS
   set pV $eS

   for { set I 0 } { $I < $ptANS($sN,Sector) } { incr I } {
      for { set J 0 } { $J < $ptANS($sID,NSEN) } { incr J } {
         set X($tE) $P($pP)
         set Y($tE) $E($J)
         set Z($tE) $V($pV)
	 incr tE
	 incr pV $ptANS($sN,nE)
      }
      incr pP $ptANS($sN,nE)
   }

# Need to grid the data unless we are fitting to the grid.

   set NeedGrid 1

# IF the data is being fit then do that. 

   if ![string match OFF $ptANS(fMethod)] { 
     
# REMOVE the drift velocity and create the fit

     PTrmDrift $sN $eS $tE X Y newX newY
     set fI [PTfitLevel $tE newX newY Z fC]

# NOW that the data is fit we either remap the intensities with the fit
#   values and then grid them or we refill the entire data grid.

      set fO $ptANS(fOrder)
      set nC [lindex $fI 0]
      set Mx [lindex $fI 1]
      if [string match DATA $ptANS(fFill)] {
         switch -exact -- $ptANS(fMethod) {
            2DPOLY {
               for { set I 0 } { $I < $tE } { incr I } {
	          set Z($I) [TUpolyExp2D $newX($I) $newY($I) $nC fC $fO]
	          set Z($I) [expr $Z($I) * $Mx]
	       }
            }
            SPH {
              for { set I 0 } { $I < $tE } { incr I } {
                  set tH [expr cos(($newY($I) + 90.0) / $RtoD)]
	          TUsphFunc $newX($I) $tH bF $fO $nC
	          set Z($I) 0
	          for { set J 0 } { $J < $nC } { incr J } {
	             set Z($I) [expr $Z($I) + $fC($J) * $bF($J)]
                  }
	          set Z($I) [expr $Z($I) * $Mx]
	       }
            }
         }
      } else {
         set NeedGrid 0
	 set sM 1
	 TUgridInfo 32 pI xP
	 TUgridInfo 33 pI yE
	 set Cut [expr $Mx / $ptANS(fCut)]
         switch -exact -- $ptANS(fMethod) {
            2DPOLY {
	       for { set I 0 ; set M 0 } { $I < $pI(4) } { incr I } {
	          for { set J 0 } { $J < $pI(5) } { incr J } {
	             set eG($M) [TUpolyExp2D $xP($I) $yE($J) $nC fC $fO]
	             set eG($M) [expr $eG($M) * $Mx]
		     if { $eG($M) < $Cut } { set eG($M) $pI(12) }
		     incr M
	          }
               }
            }
            SPH {
	       for { set I 0 } { $I < $pI(5) } { incr I } {
                   set tH($I) [expr cos(($yE($I) + 90.0) / $RtoD)]
                }

	       for { set I 0 ; set M 0 } { $I < $pI(4) } { incr I } {
	          for { set J 0 } { $J < $pI(5) } { incr J } {
	             TUsphFunc $xP($I) $tH($J) bF $fO $nC
	             set eG($M) 0
	             for { set K 0 } { $K < $nC } { incr K } {
	                set eG($M) [expr $eG($M) + $fC($K) * $bF($K)]
                     }
	             set eG($M) [expr $eG($M) * $Mx]
		     if { $eG($M) < $Cut } { set eG($M) $pI(11) }
		     incr M
                  }
	       }
            }
         }
      }
   } else {
      upvar 0 X newX
      upvar 0 Y newY
   }

# GRID data if necessary

   if $NeedGrid { TUdataGrid $tE 1 newX newX 1 newY newY Z eG NorM pI }

# SMOOTH the grid if we need to do that 

   if { $sM > 1 } {
      set OpS(0) 0.0
      set OpS(1) 1
      set EdGeS [TUgridTrim EDGES eG NorM pI OpS]
      set fInfo(0) 1
      set fInfo(1) [expr $sM * 2]
      set fInfo(2) 4
      set fInfo(3) 2
#     set fInfo(4) 0
#     set fInfo(5) 0
      set fInfo(4) [lindex $EdGeS 0]
      set fInfo(5) [lindex $EdGeS 1]
      set fInfo(6) [lindex $EdGeS 2]
      set fInfo(7) [lindex $EdGeS 3]
#     set fInfo(6) 0
#     set fInfo(7) 0
      set fInfo(8) 2.0
      set fInfo(9) 1
      TUgridFill2D eG pI NorM fInfo
   } 

# FINALLY get the max and min intensity

   set MxMn ""
   if $NeedGrid {
      set Pos [TUdataMxMn Z $tE <> 0.0]
      if { [lindex $Pos 0] >= 0 } {
         lappend MxMn $Z([lindex $Pos 0])
         lappend MxMn $Z([lindex $Pos 1])
      }
   } else {
      set tE [expr $pI(4) * $pI(5)]
      set Pos [TUdataMxMn eG $tE <> 0.0]
      if { [lindex $Pos 0] >= 0 } {
         lappend MxMn $eG([lindex $Pos 0])
         lappend MxMn $eG([lindex $Pos 1])
      } 
   }

# Mask the data if we are doing that.

   PTmaskData $sN eG pI $eS

   return $MxMn
}
