# THIS puts up all the afterplot annotation
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTaxisLabs { sN Row Col } {
   global ptANS cInputs GphInfo

   set nPS [llength $ptANS(PSrc)]
   set tF  [string match HOR $ptANS(tDir)]
   set bC  $GphInfo(bColor)
   set lS1 $ptANS(ScTs)
   set lS2 $ptANS(TmTs)

   set lC [expr $ptANS(nCol) - 1]

# INITIALIZE the label list.  Each label has associated with it the axis
#   against which its output, the label offset, the label color, the label
#   size, the label position, the label justification, and the label.

   set LabI ""

#  LOWEST top level offset and right axis offset

   set yT 0.1
   set xR -1.0

# DOES this plot need to have a scaling label added above it?  It does so
#   long as there is no colorbar and there IS a defined intensity
#   minimum value.

   if { !$ptANS(cB) && ([string length $cInputs(pMIN)] > 0) } {
#     set Lab [format "%.2e - %.2e" $cInputs(pMIN) $cInputs(pMAX)]
      set Sfmt "$ptANS(PscaFmt) - $ptANS(PscaFmt)"
      set Lab [format $Sfmt $cInputs(pMIN) $cInputs(pMAX)]
      lappend LabI [list Xt $yT $bC $lS1 CENTER center $Lab] 
      set yT [expr $yT + 1.4]
   }

# DOES this plot need to have an Time Label.  It does if its the top plot
#   in a column in a figure which has multiple energies being output OR
#   its a plot in a figure where only one energy is being output

   if { (($ptANS(eRow) > 1) && ($Row == 0)) || ($ptANS(eRow) == 1) } {
      if { $yT == 0.1 } { set yT 0.5 }
      set Lab [lindex $ptANS($sN,bT) 2]
      lappend LabI [list Xt $yT $bC $lS2 CENTER center $Lab] 
      set yT [expr $yT + 1.3]
   } 

# DOES this plot need to have an YEAR/DAY Label.  It does if its the top 
#   plot in a column in a figure which has multiple energies being outpu

   if { (($ptANS(eRow) > 1) && ($Row == 0)) } {
      set Lab "[lindex $ptANS($sN,bT) 0]/[lindex $ptANS($sN,bT) 1]"
      lappend LabI [list Xt $yT $bC $lS2 CENTER center $Lab] 
      set yT [expr $yT + 1.3]
   } 

# DOES this plot need to have an energy label?  It does if its the top plot
#   in a multisource plot being output vertically with only one energy

   if { ($nPS > 1) && ($Row == 0) } {
      if { (($ptANS(eRow) == 1) && !$tF) } {
         set yT [expr $yT + 0.7]
         set E  [lindex $ptANS($sN,eVID) 0]
         set Lab [format "$ptANS(PmevFmt) eV" $E]
         lappend LabI [list Xt $yT #0000ff $lS2 CENTER center $Lab] 
         set yT [expr $yT + 1.5]
      }
   }

# DOES this plot need to have an Spacecraft label on the top axis?  It does 
#   if its the top plot in a multisource plot being output vertially with 
#   only one energy or a mulitsource plot with more than one energy.

   if { ($nPS > 1) && ($Row == 0) } {
      if { (($ptANS(eRow) == 1) && !$tF) || ($ptANS(eRow) > 1) } {
         set Lab C-[string index $ptANS(UD$sN,M) end]
         lappend LabI [list Xt $yT #ff0000 $lS2 CENTER center $Lab] 
         set yT [expr $yT + 1.5]
      }
   }

# DOES this plot need to have an Spacecraft label on the right axis?  It does 
#   if its an end column plot in a multisource plot being output horizontally

   if { ($nPS > 1) && ($Col == $lC) } {
      if { (($ptANS(eRow) == 1) && $tF) } {
         set Lab "  C-[string index $ptANS(UD$sN,M) end]"
         lappend LabI [list Xt $xR #ff0000 $lS2 MAXIMUM right $Lab] 
         set xR [expr $xR - 2.25]
      }
   }

# DOES this plot need to have an energy and corrected energy label on the 
#   right axis?  It does if its an end column plot in a multisource plot 
#   being output horizontally OR a multiple source / multienergy plot OR 
#   if its a single source  multienergy plot.  It doesn't if its a 
#   VpVp plot howeve.

   if { ($Col == $lC) && !$ptANS(VpVp) } {
      if { ($ptANS(eRow) > 1) || (($nPS > 1) && $tF && ($ptANS(eRow) == 1)) } {
         if { ($ptANS(eRow) == 1) && ($nPS > 1) } {
            set E  [lindex $ptANS($sN,eVID) 0] 
         } else { set E  [lindex $ptANS($sN,eVID) $Row] }
         set fE [format $ptANS(PmevFmt) $E]
	 set Lab "  $fE eV"
	 set lSz [expr $lS2 + $ptANS(PmevSO)]
         lappend LabI [list Xt $xR $ptANS(PmevCO) $lSz MAXIMUM right $Lab] 
         set xR [expr $xR - 1.75]
	 if { $ptANS($sN,PV0) != 0.0 } {
	    set pE [expr $E - abs($ptANS($sN,PV0)) + $ptANS(CPV)]
            set fE [format $ptANS(PcevFmt) $pE]
	    set Lab "  $fE eV"
	    set lSz [expr $lS2 + $ptANS(PcevSO)]
            lappend LabI [list Xt $xR $ptANS(PcevCO) $lSz MAXIMUM right $Lab]
            set xR [expr $xR - 1.75]
         }
      }
   }

   return $LabI
}
