# THIS procedure puts up the plots
                                                                                
package provide ptPlots 1.0
                                                                                
proc PTacqSpin { sN ImG Elev Phase } {
   global ptANS ExDa RtoD ExPhi0 SInfo pgI

   upvar $ImG   V
   upvar $Elev  E
   upvar $Phase P

# INITIALIZE some of the monitoring variables

   set sID $ptANS($sN,sID)
   set Gap    0
   set RoLL   0
   set DoRoLL 1
   set NoSpin 1
   set vCnT 0
   set pCnT 0
   set ptANS($sN,Sector) 0
   set TheEnd [expr $ptANS($sID,NSEN) - 1 ]

# BEGIN to acquire one spin of data.

   while { $NoSpin } {

# GET the sensor data - one at a time / spin sector

      set FwD 0
      for { set I 0 } { $I <= $TheEnd } { incr I } {
         set vN [lindex $ptANS($sN,sNum) $I]

# WE don't need to read the data if it was read already which it would have
#   been most likely since it needs to be acquired to check where we are in
#   the spin

         if { $I == $TheEnd } { set FwD 1 }
         set S [ReadUDF $ptANS($sN,KeY) 0 0 $vN 0 $FwD 0]
         if { [lindex [split $S "|"] 0] != 1 } { continue }

# FOR the first sensor get the location of the last returned sample in the
#   data array, and also get the start and stop spin phase of the first 
#   element in the array.

         set nE $ExDa(0,NSMP)
         if { $I == 0 } {
            if { $vCnT == 0 } {
               set LasT [expr $ExDa(0,NSMP) - 1]
               set EnD [expr $ExPhi0(0)  + 360.0]
               set BeG $ExPhi0(0)
            }
            if { $ptANS($sN,Sector) == 0 } {
               set ptANS($sN,bY) $ExDa(0,BYR)
               set ptANS($sN,bD) $ExDa(0,BDY)
               set ptANS($sN,bM) $ExDa(0,BMSEC)
               set LastMs   $ExDa(0,BMSEC)
	       set Spin     $ExDa(0,SPIN)
	       set LastPhi  $ptANS(Bad)

	       if { $ExPhi0(0) > $ExPhi0($LasT) } {
	          set MaxRoLL 2
	       } else { set MaxRoLL 1 }

	       set fsT -1

               set sdT [expr $ExDa(0,EMSEC) - $ExDa(0,BMSEC)]
               if { $sdT < 0 } { set sdT [expr $sdT + 86400000] }
               set ptANS($sN,GapDt) [expr int($sdT * $ptANS(FrGap))]
	       set ptANS($sN,bT) [TUtimeFmt 0 $ExDa(0,BYR) $ExDa(0,BDY) \
	                                  $ExDa(0,BMSEC) $ExDa(0,BNSEC)]
               set ptANS($sN,nE) $nE
               PTeLims $sN
            }
            set yR($ptANS($sN,Sector)) $ExDa(0,EYR)
            set dY($ptANS($sN,Sector)) $ExDa(0,EDY)
            set mS($ptANS($sN,Sector)) $ExDa(0,EMSEC)
            set CurMs  $ExDa(0,EMSEC)
            set CurPhi $ExPhi0(0)
             
	    if { ($ExPhi0($LasT) < $ExPhi0(0)) && $DoRoLL } {
              incr RoLL
              if { $RoLL >= $MaxRoLL } { set DoRoLL 0 }
            } elseif { $ExPhi0($LasT) > $BeG } { set DoRoLL 1 }

            set T [expr $ExPhi0($LasT) + $RoLL * 360.0]
                                                                                
	    if { $ptANS($sN,Sector) > 35 } {exit }
            if { ($T > $EnD) || $Gap } { set NoSpin 0 ; break }
            if $Gap { set NoSpin 0 ; break }

	    if { ($fsT < 0) && ($ptANS($sN,Sector) > 1) } {
	       set dT [expr $CurMs - $LastMs]
	       if { $dT < 0 } { set dT [expr $dT + 86400000] }
	       if { $dT < [expr 2.0 * $sdT] } { set fsT $dT }
	    }

            set LastMs $CurMs
            set LastPhi $CurPhi

            for { set J 0 } { $J < $nE } { incr J ; incr pCnT } {
               set P($pCnT) [expr fmod(($ExPhi0($J) + $ptANS(pLook)), 360.0)]
#       if { $ptANS(MinPhi) < 0.0 } {
#           if { $PhI > $ptANS(MaxPhi) } { set PhI [expr $PhI - 360.0] }
#       }
#              set P($pCnT) $PhI
            }
         }

         if { $vCnT == 0 } { 
	    set ThetA $ptANS($sN,KeY),0,GN,THETA
	    set Q [expr ($TheEnd + 1)]
            for { set J 0 } { $J <= $TheEnd } { incr J ; incr Q } {
	       set ThA [lindex $SInfo($ThetA) $J]
	       set ThB [lindex $SInfo($ThetA) $Q]
	       set ThC [expr $ThA + ($ThB - $ThA) / 2.0]
	       set E($J) [expr $ptANS(tLook) * (90.0 - $ThC)]
            }
         }

         set uI [lindex $ptANS($sN,sUnit) $I]
         ConvertToUnits $ptANS($sN,KeY) 0 0 $uI rV
         for { set J 0 } { $J < $nE } { incr J ; incr vCnT } {
             set V($vCnT) $rV($J)
         } 
      }
      incr ptANS($sN,Sector)
   }

   set ptANS($sN,FirstRead) 0
   set ptANS($sN,nE) $nE
   set ptANS($sN,SpiN) $ExDa(0,SPIN)
   incr ptANS($sN,Sector) -1
   set EnD [expr $ptANS($sN,Sector) - 1]
   set ptANS($sN,eY) $yR($EnD)
   set ptANS($sN,eD) $dY($EnD)
   set ptANS($sN,eM) $mS($EnD)

   PTclipData $sN V P

   set tSec [expr int($Spin / double($fsT) + .5)]
   if { $ptANS(FrGap) <= [expr $tSec - $ptANS($sN,Sector)] } { set Gap 1 }
   if { $fsT <= 0 } { set Gap 1 }

   if $Gap { set retStat 0 } else { set retStat 1 }

# SET the required grid size for this data set

   if { $ptANS(Smooth) <= 0 } { set sFac 1 } else { set sFac $ptANS(Smooth) }
   set pgI(4) [expr $ptANS($sN,Sector) * $sFac ]
   set pgI(5) [expr $ptANS($sID,NSEN) * $sFac ]

   return $retStat
}
