# THIS procedure acquires the measurements from a single CAA source during
#   the duration of one of the moments computation.

# IN the procedure:
#   tChk == 0 : measurement time is earlier than the time of the moments
#   tChk == 1 : measurement time is within than the time of the moments
#   tChk == 2 : measurement time is later than the time of the moments

package provide ptPlots 1.0

proc PTacqCAA { psN sN Src rV fV } {
   global ptANS

   upvar $rV V
   upvar $fV aV

   if [string match MAGFIELD $Src] {
      set FmT "%d-%d-%dT%d:%d:%fZ,%f,%f,%f,%f,"
      set rCmD {scan $LiNe $FmT bY bMo bD bH bM bS _T1 S(0) S(1) S(2)}
      set nS 3
   } else {
      set FmT "%d-%d-%dT%d:%d:%fZ,%f,%f,"
      set rCmD {scan $LiNe $FmT bY bMo bD bH bM bS _T1 S(0)}
      set nS 1
   } 

   # INITIALIZE the normalization and values for the sensors 

   for { set I 0 } { $I < $nS } { incr I } {
      set Norm($I) 0.0
      set V($I)  0.0
   }

# CHECK to see where this sensor stands with respect to the time of the
#   current moment calculation

   if { $ptANS($sN,tChk) > 1 } {
      set ptANS($sN,tChk) [PTtimeCheck $psN $sN Fr]
      if { ($ptANS($sN,tChk) == 1) || ($ptANS($sN,tChk) == 3) } {
         for { set I 0 } { $I < $nS } { incr I } {
            set V($I) [expr $Fr * $ptANS($sN,cV$I)]
            set Norm($I) $Fr
         }
      }
   }

# THIS is the acquisition loop.  Acquire the sensors so long as their 
#   center time is within the time of the moments computation.  Forward
#   on the last sensor

   set Sets 0
   set nE 0

   while { $ptANS($sN,tChk) < 2 } { 
      set EOF [gets $ptANS($sN,fd) LiNe] 
      if { $EOF <= 0 } { set ptANS($sN,EOF) 1 ; return 0 }
      eval $rCmD

      set YD [TUtimeFmt 5 $bY $bMo $bD]
      scan $YD "%4d%3d" bY bD
      set bMs [expr int(($bH * 3600 + $bM * 60 + $bS) * 1000)]

      set ptANS($sN,bfYr) $bY
      set ptANS($sN,efYr) $bY
      set ptANS($sN,bfDy) $bD
      set ptANS($sN,efDy) $bD
      set ptANS($sN,bfMs) $bMs
      set ptANS($sN,efMs) [expr $bMs + $ptANS($sN,dT)]
      if { $ptANS($sN,efMs) > 86400000 } {
         set ptANS($sN,efMs) [ expr $ptANS($sN,efMs) - 86400000]
         incr ptANS($sN,efDy) 
	 if { $$ptANS($sN,efDy) > [TUyearLeap $ptANS($sN,efYr)] } {
            set ptANS($sN,efDy) 1 
            incr ptANS($sN,efYr) 
         }
      }

      set ptANS($sN,tChk) [PTtimeCheck $psN $sN Fr]

      if { ($ptANS($sN,tChk) == 1) || ($ptANS($sN,tChk) == 3) } { 
         incr Sets
         for { set I 0 } { $I < $nS } { incr I ; incr nE } { 
            set V($I) [expr $V($I) + $Fr * $S($I)] 
            set Norm($I) [expr $Norm($I) + $Fr]
	    set aV($nE) $S($I)
         }
      }
   }

   set aV(nSets) $Sets
   set aV(nVal)  $nE

   for { set I 0 } { $I < $nS } { incr I } { set ptANS($sN,cV$I) $S($I) }

   if { $Norm(0) > 0 } {
      for { set I 0 } { $I < $nS } { incr I } { 
          set V($I) [expr $V($I) / $Norm($I)] 
      }
   } else {
      for { set I 0 } { $I < $nS } { incr I } { 
         set V($I) $ptANS(Bad)
      }
   }

   return $nS
}
