package provide TclPLT 1.0

# INPUTS
#  
#  pN      -  Plot Window Number
#  Phi     -  Array of Phi Values (used in 1D plots) 
#  Rad     -  Array of Radii Values (used in 1D plots) 
#  Grid    -  Intensities in 1D plots or Data Grid for 2D plots
#  Ops Array
#    Index 0 : Angle Info: 0 - Degrees; 1 - Radians
#    Index 1 : Starting location in array for 1D plots
#    Index 2 : Ending location in array for 1D plots
#    Index 3 : 1D Plot Format  (LINE, SCATTER)
#    Index 4 : Scatter Font
#    Index 5 : Scatter Font Size
#    Index 6 : Scatter Symbol
#    Index 7 : 1D - Plot Color (VALUE or -1 for variable)
#    Index 8 : Data Exclusion : NONE < > >= <= ==  
#    Index 9 : Data Exclusoin Value
#    Index 10 : Data Phi Rotation Value - Radians
                
proc PolarPlot { pN Phi Rad Grid gInfo Ops cInfo } {
   global WinInfo PltInfo GphInfo RtoD

#  Get the curent window number

   set wN $PltInfo($pN,wN)

   upvar $Phi   P
   upvar $Rad   R
   upvar $Grid  V
   upvar $gInfo gI
   upvar $cInfo cI
   upvar $Ops   oP

   set OldClip $WinInfo($wN,Clip)
   if { [array exists P] && [array exists R] } { set pT 1 } else { set pT 2 } 

# OK .. SET up the defaults

   set aF 0
   set pOff 0.0
   if { $pT == 1 } { 
      set Cmd { set OK 1 }
      set pC $GphInfo(White)
      PlotColor HOLD $pC OFF
      set pF LINE
      set sF HOLD
      set sZ 10
      set sS *
      set BeG 0
      set EnD [expr [array size P] - 1]
      set Lim 1.0e30
   }

# NOW .. Modify any of the defaults which the user may have changed

   if [array exists oP ] {
      if [info exists oP(0)] { set aF $oP(0) } 
      if { $pT == 1 } { 
         if [info exists oP(1)] { set BeG $oP(1) }
         if [info exists oP(2)] { set EnD $oP(2) }
         if [info exists oP(3)] { set pF  $oP(3) }
         if [info exists oP(4)] { set pF  $oP(4) }
         if [info exists oP(5)] { set sZ  $oP(5) }
         if [info exists oP(6)] { set sS  $oP(6) }
         if [info exists oP(7)] { set pC  $oP(7) }
      }
      if [info exists oP(9)] { set Lim   $oP(9) }
      if [info exists oP(10)] { set pOff   $oP(10) }
      if [info exists oP(8)] { 
          switch -exact -- $oP(8) {
             ==   { set Cmd { if { $Y($I) == $Val } { set OK 0 } } }
             >    { set Cmd { if { $Y($I) > $Val }  { set OK 0 } } }
             <    { set Cmd { if { $Y($I) < $Val }  { set OK 0 } } }
             >=   { set Cmd { if { $Y($I) >= $Val } { set OK 0 } } }
             <=   { set Cmd { if { $Y($I) <= $Val } { set OK 0 } } }
             NONE { set Cmd {set OK 1 } }
          }
      }
   }

   if { $pT == 1 } {
      if { $aF == 0 } { set cV [expr 1.0 / $RtoD] } else { set cV 1.0 }
      switch -exact -- $pF { 
         SCATTER {
            TextProp $sZ $sF
            for { set I $BeG } { $I <= $EnD } { incr I } { 
               eval $Cmd
               if {$OK} {
                  set AnG [expr $cV * $P($I) + $pOff]
                  set X [expr $R($I) * cos($AnG)]
                  set Y [expr $R($I) * sin($AnG)]
                  if { $pC < 0 } { 
                     if { $cI(4) == 1 } {
                        if {$V($K) > 0.0 } {
                           set C [expr int($cI(0) * log10($V($K)) + $cI(1))]
                        } else { set C -1 }
                     } else { set C [expr int($cI(0) * $V($K) + $cI(1))] }
                     if { $C > $cI(3) } { set C $cI(3) }
                  } else { set C $pC }
                  TexT $wN $X $Y 0.0 center $sS $C
               } else { set OK 1 }
            }
         }
         LINE {
            set First 1
            for { set I $BeG } { $I <= $EnD } { incr I } { 
               eval $Cmd
               if {$OK} {
                  set AnG [expr $cV * $P($I) + $pOff]
                  set X [expr $R($I) * cos($AnG)]
                  set Y [expr $R($I) * sin($AnG)]
                  if { $pC < 0 } { 
                     if { $cI(4) == 1 } {
                        if {$V($K) > 0.0 } {
                           set C [expr int($cI(0) * log10($V($K)) + $cI(1))]
                        } else { set C -1 }
                     } else { set C [expr int($cI(0) * $V($K) + $cI(1))] }
                     if { $C > $cI(3) } { set C $cI(3) }
                  } else { set C $pC }
                  if {$First} {
                     GPHlineData $X $Y 0.0 0 0
                     set First 0
                  } else { GPHlineData $X $Y 0.0 1 0 }
               } else { 
               set OK 1 
               if { $First == 0 } { GPHlineData $X $Y 0.0 0 2 }
                  set First 1
               }
            }
            GPHlineData 0.0 0.0 0.0 0 2
         }
      }
   } else {
      set pOff [expr $pOff * $RtoD]
      if { $aF == 0 } { set cV 1.0 } else { set cV $RtoD }
      if { $WinInfo($wN,p0) > $WinInfo($wN,p3) } {
          set xMax $WinInfo($wN,p0) ; set xMin $WinInfo($wN,p3) 
      } else { set xMax $WinInfo($wN,p3) ; set xMin $WinInfo($wN,p0) } 
      if { $WinInfo($wN,p1) > $WinInfo($wN,p4) } {
          set yMax $WinInfo($wN,p1) ; set yMin $WinInfo($wN,p4) 
      } else { set yMax $WinInfo($wN,p4) ; set yMin $WinInfo($wN,p1) } 

      set dP [expr ($gI(1) - $gI(0)) / double($gI(4)) / 2.0 ]
      set dR [expr ($gI(3) - $gI(2)) / double($gI(5)) / 2.0 ]
      for { set gY [expr $gI(5) - 1] } { $gY >= 0 } { incr gY -1 } { 
         for { set gX 0 } { $gX < $gI(4) } { incr gX } { 
            TUgridInfo 1 gI rV $gX $gY
            if { $V($rV(0)) > -9.0e30 } {
               if { $cI(4) == 1 } {
                  if {$V($rV(0)) > 0.0 } {
                     set C [expr int($cI(0) * log10($V($rV(0))) + $cI(1))]
                   } else { set C -1 }
               } else { set C [expr int($cI(0) * $V($rV(0)) + $cI(1))] }
               if { $C > $cI(3) } { set C $cI(3) }
               PlotColor HOLD $C $C
               TUgridInfo 20 gI rV $rV(0)
               set P1 [expr ($rV(2) - $dP) * $cV + $pOff] 
               set P2 [expr ($rV(2) + $dP) * $cV + $pOff] 
               set R1 [expr $rV(3) + $dR] 

               set X [expr $R1 * cos(($P1 + $P2) / 2.0 / $RtoD)]
               if { ($X >= $xMin) && ($X <= $xMax) } { 
                  set Y [expr $R1 * sin(($P1 + $P2) / 2.0 / $RtoD)]
                  if { ($Y >= $yMin) && ($Y <= $yMax) } { 
                     set X [expr $R1 * cos($P1 / $RtoD)]
                     if { ($X >= $xMin) && ($X <= $xMax) } { 
                        set X [expr $R1 * cos($P2 / $RtoD)]
                        if { ($X >= $xMin) && ($X <= $xMax) } { 
                           set Y [expr $R1 * sin($P1 / $RtoD)]
                           if { ($Y >= $yMin) && ($Y <= $yMax) } { 
                              set Y [expr $R1 * sin($P2 / $RtoD)]
                              if { ($Y >= $yMin) && ($Y <= $yMax) } { 
                                 Arc $wN 0.0 0.0 0.0 $R1 $P1 $P2 1 0 1.0 
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
      PlotColor HOLD 0 0
      TUgridInfo 20 gI rV 0
      set R1 [expr $rV(3) - $dR] 
      Arc $wN 0.0 0.0 0.0 $R1 0.0 360.0 1 0 1.0
      PlotColor HOLD 255 OFF
   }
}
