package provide TclPLT 1.0

# INPUTS
#  
#  pN      -  Plot Number
#  Data1   -  Array of X values
#  Data2   -  Array of Y values
#  Beg     -  Starting point in plot
#  End     -  Ending point in plot
#  Format  -  Plot format ; SCATTER : LINE
#  OpsY List
#    Index 0 : Plot Color
#    Index 1 : Data Exclusion : NONE < > >= <= ==  
#    Index 2 : Data Exclusoin Value
#    Index 3 : Scatter Font
#    Index 4 : Scatter Font Size
#    Index 5 : Scatter Value
#  OpsX List
#    Index 0 : Data Exclusion : NONE < > >= <= ==  
#    Index 1 : Data Exclusoin Value
                
proc Plot2D { pN Xaxis Yaxis Data1 Data2 Beg End Format OpsY {OpsX ""} } {
   global WinInfo PltInfo GphInfo 

   upvar $Data1 X
   upvar $Data2 Y

#  Get the curent window number

   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN

# IF no begin and end set then well set it here

   if { $Beg < 0 } {
      set Beg 0
      set End [expr [array size Y ] - 1]
   } 
   
# REDO the opts for input to the individual plotting routines

   set oXL [llength $OpsX]
   set oYL [llength $OpsY]

   if { $oYL > 0 } { set cC [lindex $OpsY 0] } else { set cC 255 }
   if { $oYL > 3 } { set cF [lindex $OpsY 3] } else { set cF HOLD }
   if { $oYL > 4 } { set cS [lindex $OpsY 4] } else { set cS 10 }
   if { $oYL > 5 } { set cH [lindex $OpsY 5] } else { set cH "+" }
   
   if { $oXL > 0 } { set eX [lindex $OpsX 0] } else { set eX NONE }
   if { $oXL > 1 } { set xV [lindex $OpsX 1] } else { set xV  0 }
   if { $oYL > 1 } { set eY [lindex $OpsY 1] } else { set eY NONE }
   if { $oYL > 2 } { set yV [lindex $OpsY 2] } else { set yV 0 }

   switch -exact -- $Format { 
      SCATTER { 
         set Ops [list 2D $cC $cF $cS $cH] 
         set ExC [list $eX $xV $eY $yV ] 
         PLTscatterPlot $wN $Xaxis $Yaxis X Y Z V $Beg $End $Ops cI $ExC 
      }
      LINE {
         set Ops [list 2D $cC] 
         set ExC [list $eX $xV $eY $yV] 
         PLTlinePlot $wN $Xaxis $Yaxis X Y Z $Beg $End $Ops $ExC 
      }
      HISTOGRAM {
         set Ops [list 2D $cC]
         set ExC [list $eX $xV $eY $yV] 
         PLThistogramPlot $wN $Xaxis $Yaxis X Y Z $Beg $End $Ops $ExC 
      }
   }
}
