package provide TclPLT 1.0

# THIS routine is a VTK programmable filter which renders a data grid
#   into a 2D PolyData Source  

proc PLTvtk3DGrid { wN xX yY Grid gInfo cInfo } {
   global GPHRender WinInfo colorLUT GphInfo

   upvar $xX _X
   upvar $yY _Y
   upvar $Grid G
   upvar $gInfo gI
   upvar $cInfo cI

# GET the correct set of axis scaled

   GPHwinScale $wN Xp Yp Zc 0

# THESE are the grid array definitions

   vtkFloatArray X$wN
   vtkFloatArray Y$wN
   vtkFloatArray Z$wN
   vtkFloatArray V$wN

# SINCE there is only one Z plane we can populate that now

   Z$wN InsertNextValue 0.0

# Slopes and intercepts that are used to convert X and Y to pixels

   set Sx $WinInfo($wN,s0)
   set Ix $WinInfo($wN,i0)
   set Sy $WinInfo($wN,s1)
   set Iy $WinInfo($wN,i1)

# GET the data out of the grid 

   for {set R 0} {$R < $gI(5)} {incr R} {
      for {set C 0} {$C < $gI(4)} {incr C } {
 	 TUgridInfo 1 gI rV $C $R
         if { $R == 0 } { X$wN InsertNextValue [expr $_X($C) * $Sx + $Ix] }
         if { $C == 0 } { Y$wN InsertNextValue [expr $_Y($R) * $Sy + $Iy] }
         V$wN InsertNextValue [GetColor $G($rV(0)) cI]
      }
   }

# CREATE and populate the grid

   vtkRectilinearGrid rGriD$wN
      rGriD$wN SetDimensions $gI(4) $gI(5) 1
      rGriD$wN SetXCoordinates X$wN
      rGriD$wN SetYCoordinates Y$wN
      rGriD$wN SetZCoordinates Z$wN
      [rGriD$wN GetPointData] SetScalars V$wN

# GET the grid plane

   vtkRectilinearGridGeometryFilter gPlane$wN
      gPlane$wN SetInput rGriD$wN
      gPlane$wN SetExtent 0  [expr $gI(4) - 1]  0  [expr $gI(5) - 1]  0  0

# WARP the grid according to the scalars

   vtkWarpScalar gWarp$wN
      gWarp$wN SetInput [gPlane$wN GetOutput]
      gWarp$wN SetScaleFactor $GphInfo(vtkSFac)

# MAP the grid 

   vtkDataSetMapper gMapper$wN
      gMapper$wN SetInput [gWarp$wN GetOutput ]
      gMapper$wN SetScalarRange 0 254
      gMapper$wN SetLookupTable colorLUT

# SET the actor

   vtkActor gActor$wN
      gActor$wN SetMapper gMapper$wN

# ADD the actor to the renderer

    GPHRender AddActor gActor$wN
}
